//---------------------------------------------------------------------------
//
//	File:			DDDIAG.CPP
//	Programmer:		Bob Provencher
//	Create Date:	7/15/95
//	Last Mod Date:	8/9/95
//	Description:	
//
//	Copyright (c) 1995 Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "dddiag.h"
#include "ddsamp.h"

SCODE				sCode;				// result of Direct Draw methods

ofstream trace;

ErrorDesc		errorList[] =
{
    { DD_OK,                             "DD_OK"                           },
    { DDERR_ALREADYINITIALIZED,          "DDERR_ALREADYINITIALIZED"        }, 
    { DDERR_CANNOTATTACHSURFACE,         "DDERR_CANNOTATTACHSURFACE"       }, 
    { DDERR_CANNOTDETACHSURFACE,         "DDERR_CANNOTDETACHSURFACE"       }, 
    { DDERR_CURRENTLYNOTAVAIL,           "DDERR_CURRENTLYNOTAVAIL"         }, 
    { DDERR_EXCEPTION,                   "DDERR_EXCEPTION"                 }, 
    { DDERR_GENERIC,                     "DDERR_GENERIC"                   }, 
    { DDERR_HEIGHTALIGN,                 "DDERR_HEIGHTALIGN"               }, 
    { DDERR_INCOMPATIBLEPRIMARY,         "DDERR_INCOMPATIBLEPRIMARY"       }, 
    { DDERR_INVALIDCAPS,                 "DDERR_INVALIDCAPS"               }, 
    { DDERR_INVALIDCLIPLIST,             "DDERR_INVALIDCLIPLIST"           }, 
    { DDERR_INVALIDMODE,                 "DDERR_INVALIDMODE"               }, 
    { DDERR_INVALIDOBJECT,               "DDERR_INVALIDOBJECT"             }, 
    { DDERR_INVALIDPARAMS,               "DDERR_INVALIDPARAMS"             }, 
    { DDERR_INVALIDPIXELFORMAT,          "DDERR_INVALIDPIXELFORMAT"        }, 
    { DDERR_INVALIDRECT,                 "DDERR_INVALIDRECT"               },
    { DDERR_LOCKEDSURFACES,              "DDERR_LOCKEDSURFACES"            },
    { DDERR_NO3D,                        "DDERR_NO3D"                      },
    { DDERR_NOALPHAHW,                   "DDERR_NOALPHAHW"                 },
    { DDERR_NOCLIPLIST,                  "DDERR_NOCLIPLIST"                },
    { DDERR_NOCOLORCONVHW,               "DDERR_NOCOLORCONVHW"             },
    { DDERR_NOCOOPERATIVELEVELSET,       "DDERR_NOCOOPERATIVELEVELSET"     },
    { DDERR_NOCOLORKEY,                  "DDERR_NOCOLORKEY"                },
    { DDERR_NOCOLORKEYHW,                "DDERR_NOCOLORKEYHW"              },
    { DDERR_NOEXCLUSIVEMODE,             "DDERR_NOEXCLUSIVEMODE"           },
    { DDERR_NOFLIPHW,                    "DDERR_NOFLIPHW"                  },
    { DDERR_NOGDI,                       "DDERR_NOGDI"                     },
    { DDERR_NOMIRRORHW,                  "DDERR_NOMIRRORHW"                },
    { DDERR_NOTFOUND,                    "DDERR_NOTFOUND"                  },
    { DDERR_NOOVERLAYHW,                 "DDERR_NOOVERLAYHW"               },
    { DDERR_NORASTEROPHW,                "DDERR_NORASTEROPHW"              },
    { DDERR_NOROTATIONHW,                "DDERR_NOROTATIONHW"              },
    { DDERR_NOSTRETCHHW,                 "DDERR_NOSTRETCHHW"               },
    { DDERR_NOT4BITCOLOR,                "DDERR_NOT4BITCOLOR"              },
    { DDERR_NOT4BITCOLORINDEX,           "DDERR_NOT4BITCOLORINDEX"         },
    { DDERR_NOT8BITCOLOR,                "DDERR_NOT8BITCOLOR"              },
    { DDERR_NOTEXTUREHW,                 "DDERR_NOTEXTUREHW"               },
    { DDERR_NOVSYNCHW,                   "DDERR_NOVSYNCHW"                 },
    { DDERR_NOZBUFFERHW,                 "DDERR_NOZBUFFERHW"               },
    { DDERR_NOZOVERLAYHW,                "DDERR_NOZOVERLAYHW"              },
    { DDERR_OUTOFCAPS,                   "DDERR_OUTOFCAPS"                 },
    { DDERR_OUTOFMEMORY,                 "DDERR_OUTOFMEMORY"               },
    { DDERR_OUTOFVIDEOMEMORY,            "DDERR_OUTOFVIDEOMEMORY"          },
    { DDERR_OVERLAYCANTCLIP,             "DDERR_OVERLAYCANTCLIP"           },
    { DDERR_OVERLAYCOLORKEYONLYONEACTIVE,"DDERR_OVERLAYCOLORKEYONLYONEACTIVE" },
    { DDERR_PALETTEBUSY,                 "DDERR_PALETTEBUSY"               },
    { DDERR_COLORKEYNOTSET,              "DDERR_COLORKEYNOTSET"            },
    { DDERR_SURFACEALREADYATTACHED,      "DDERR_SURFACEALREADYATTACHED"    },
    { DDERR_SURFACEALREADYDEPENDENT,     "DDERR_SURFACEALREADYDEPENDENT"   },
    { DDERR_SURFACEBUSY,                 "DDERR_SURFACEBUSY"               },
    { DDERR_SURFACEISOBSCURED,           "DDERR_SURFACEISOBSCURED"         },
    { DDERR_SURFACELOST,                 "DDERR_SURFACELOST"               },
    { DDERR_SURFACENOTATTACHED,          "DDERR_SURFACENOTATTACHED"        },
    { DDERR_TOOBIGHEIGHT,                "DDERR_TOOBIGHEIGHT"              },
    { DDERR_TOOBIGSIZE,                  "DDERR_TOOBIGSIZE"                },
    { DDERR_TOOBIGWIDTH,                 "DDERR_TOOBIGWIDTH"               },
    { DDERR_UNSUPPORTED,                 "DDERR_UNSUPPORTED"               },
    { DDERR_UNSUPPORTEDFORMAT,           "DDERR_UNSUPPORTEDFORMAT"         },
    { DDERR_UNSUPPORTEDMASK,             "DDERR_UNSUPPORTEDMASK"           },
    { DDERR_VERTICALBLANKINPROGRESS,     "DDERR_VERTICALBLANKINPROGRESS"   },
    { DDERR_WASSTILLDRAWING,             "DDERR_WASSTILLDRAWING"           },
    { DDERR_XALIGN,                      "DDERR_XALIGN"                    },
//    { DDERR_INVALIDDIRECTDRAWUIID,       "DDERR_INVALIDDIRECTDRAWUIID"     },
    { DDERR_DIRECTDRAWALREADYCREATED,    "DDERR_DIRECTDRAWALREADYCREATED"  },
    { DDERR_NODIRECTDRAWHW,              "DDERR_NODIRECTDRAWHW"            },
    { DDERR_PRIMARYSURFACEALREADYEXISTS, "DDERR_PRIMARYSURFACEALREADYEXISTS" },   
    { DDERR_NOEMULATION,                 "DDERR_NOEMULATION"               },
    { DDERR_REGIONTOOSMALL,              "DDERR_REGIONTOOSMALL"            },
    { DDERR_CLIPPERISUSINGHWND,          "DDERR_CLIPPERISUSINGHWND"        },
    { DDERR_NOCLIPPERATTACHED,           "DDERR_NOCLIPPERATTACHED"         },
    { DDERR_NOHWND,                      "DDERR_NOHWND"                    },
    { DDERR_HWNDSUBCLASSED,              "DDERR_HWNDSUBCLASSED"            },
    { DDERR_HWNDALREADYSET,              "DDERR_HWNDALREADYSET"            },
    { DDERR_NOPALETTEATTACHED,           "DDERR_NOPALETTEATTACHED"         },
    { DDERR_NOPALETTEHW,                 "DDERR_NOPALETTEHW"               },
    { DDERR_BLTFASTCANTCLIP,             "DDERR_BLTFASTCANTCLIP"           }, 
    { DDERR_NOBLTHW,                     "DDERR_NOBLTHW"                   },  
    { DDERR_NODDROPSHW,                  "DDERR_NODDROPSHW"                }, 
    { DDERR_OVERLAYNOTVISIBLE,           "DDERR_OVERLAYNOTVISIBLE"         }, 
    { DDERR_NOOVERLAYDEST,               "DDERR_NOOVERLAYDEST"             }, 
    { DDERR_INVALIDPOSITION,             "DDERR_INVALIDPOSITION"           }, 
    { DDERR_NOTAOVERLAYSURFACE,          "DDERR_NOTAOVERLAYSURFACE"        }, 
    { DDERR_EXCLUSIVEMODEALREADYSET,     "DDERR_EXCLUSIVEMODEALREADYSET"   }, 
    { DDERR_NOTFLIPPABLE,                "DDERR_NOTFLIPPABLE"              }, 
    { DDERR_CANTDUPLICATE,               "DDERR_CANTDUPLICATE"             }, 
    { DDERR_NOTLOCKED,                   "DDERR_NOTLOCKED"                 }, 
    { DDERR_CANTCREATEDC,                "DDERR_CANTCREATEDC"              }, 
    { DDERR_NODC,                        "DDERR_NODC"                      }, 
    { DDERR_WRONGMODE,                   "DDERR_WRONGMODE"                 }, 
    { DDERR_IMPLICITLYCREATED,           "DDERR_IMPLICITLYCREATED"         }, 
    { DDERR_NOTPALETTIZED,               "DDERR_NOTPALETTIZED"             }, 
    { DDERR_UNSUPPORTEDMODE,             "DDERR_UNSUPPORTEDMODE"           },
    { 0xFFFFFFFF,                        "UNDEFINED"                       }
};

const UINT numErrors = sizeof( errorList ) / sizeof( errorList[ 0 ] ); 

UINT FindErrorIndex( SCODE sCode )
{
	for ( UINT i = 0; i < numErrors - 1; i++ )
		if ( sCode == errorList[ i ].sCode )
			break;
    return i;
}

char* GetErrorDesc( SCODE sCode )
{
    return errorList[ FindErrorIndex( sCode ) ].sCodeStr;
}

BOOL Diagnose( char* file, UINT line, SCODE s )
{

	trace << file << " line " << line << ": SCODE: " << SCODE_CODE( s )
		  << ", Error: " << GetErrorDesc( sCode ) << "\n"; 

    trace.flush();

	return SUCCEEDED( sCode );

}

void Message( char* msg, UINT style )
{
	MessageBox( hWndMain, msg, lpszDirectDraw, style );
}
