// dcbdlg.cpp : implementation file
//

#include "stdafx.h"
#include "pkt95.h"
#include "dcbdlg.h"
#include "commdoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDcbDlg dialog


CDcbDlg::CDcbDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDcbDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDcbDlg)
	m_fullduplex = FALSE;
	m_port = _T("");
	m_baud = _T("");
	m_bits = _T("");
	m_parity = _T("");
	m_stop = _T("");
	//}}AFX_DATA_INIT
}


void CDcbDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDcbDlg)
	DDX_Check(pDX, DUPLEX_BOX, m_fullduplex);
	DDX_CBString(pDX, PORT_BOX, m_port);
	DDX_CBString(pDX, BAUD_BOX, m_baud);
	DDX_CBString(pDX, BIT_BOX, m_bits);
	DDX_CBString(pDX, PARITY_BOX, m_parity);
	DDX_CBString(pDX, STOP_BOX, m_stop);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDcbDlg, CDialog)
	//{{AFX_MSG_MAP(CDcbDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDcbDlg message handlers

int CDcbDlg::GetDCB(CCommDoc *doc)
  {
  CDcbDlg dlg;
  dlg.m_fullduplex=doc->fullduplex;
  dlg.m_port=doc->port;
  dlg.m_baud.Format("%d",doc->dcb.BaudRate);
  dlg.m_bits.Format("%d",doc->dcb.ByteSize);
  switch (doc->dcb.Parity)
    {
	case EVENPARITY:
	  dlg.m_parity="Even";
	  break;

	case ODDPARITY:
	  dlg.m_parity="Odd";
	  break;

	case NOPARITY:
	  dlg.m_parity="None";
	  break;

	case MARKPARITY:
	  dlg.m_parity="Mark";
	  break;
	}
  switch (doc->dcb.StopBits)
    {
	case ONESTOPBIT:
	   dlg.m_stop="1";
	   break;

	case ONE5STOPBITS:
	   dlg.m_stop="1.5";
	   break;

	case TWOSTOPBITS:
	   dlg.m_stop="2";
	   break;
	}

  if (dlg.DoModal()==IDOK)
    {
	doc->port=dlg.m_port;
	doc->fullduplex=dlg.m_fullduplex;
	doc->dcb.BaudRate=atoi(dlg.m_baud);
	doc->dcb.ByteSize=atoi(dlg.m_bits);
	doc->dcb.fParity=1;
	if (dlg.m_parity=="Odd")
	  doc->dcb.Parity=ODDPARITY;
	else if (dlg.m_parity=="Even")
	  doc->dcb.Parity=EVENPARITY;
	else if (dlg.m_parity=="Mark")
	  doc->dcb.Parity=MARKPARITY;
	else if (dlg.m_parity=="None")
	  {
	  doc->dcb.Parity=NOPARITY;
	  doc->dcb.fParity=0;
	  }
	if (dlg.m_stop=="1")
	  doc->dcb.StopBits=ONESTOPBIT;
	else if (dlg.m_stop=="2")
	  doc->dcb.StopBits=TWOSTOPBITS;
	else if (dlg.m_stop=="1.5")
	  doc->dcb.StopBits=ONE5STOPBITS;
	return IDOK;
	}
  return IDCANCEL;
  }


