// CommDoc.h : interface of the CCommDoc class
//
/////////////////////////////////////////////////////////////////////////////

// Message to send to views when characters arrive
#define WM_COMMCHAR (WM_USER+250)

// Structure to pass to COMM Thread
// Note that w must not be a CWnd -- threads can only use MFC 
// objects they create

class CCommDoc;  // forward reference

struct CommThreadArg
  {
  HANDLE com;  /* file handle */
  CCommDoc *docptr; /* Document class */
  };

class CCommDoc : public CDocument
{
protected: // create from serialization only
	CCommDoc();
	DECLARE_DYNCREATE(CCommDoc)

// Attributes
public:
   BOOL fullduplex;  // controls echo operation
   BOOL nulls;       // allow null bytes?
   DCB dcb;	// Device control block
   CString port;

protected:
   HANDLE comport;  // com file
   CWinThread *iotask;  // Comm thread
   CommThreadArg commargs;  // Arguments to Comm thread
   virtual void CharsIn(LPSTR buf,unsigned ct);
   
// Operations
public:
   BOOL Init(LPCSTR port,DCB *idcb=NULL);  // setup
   BOOL Write(char c);			   // Write to port
   BOOL Write(LPCSTR s);
   void Echo(char c);			   // Echo to view
   int SetProps(void);			   // Setup properties

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCommDoc)
	public:
	virtual BOOL OnNewDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCommDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	

protected:
	 static UINT CommThread(LPVOID param); // worker thread for I/O

// Generated message map functions
protected:
	//{{AFX_MSG(CCommDoc)
	afx_msg void OnProp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
