(*-------------------------------------------*)
(*                                           *)
(* Unit to check PWindowsObject's validity   *)
(*                                           *)
(* Contains two routines.                    *)
(* - check that object is valid              *)
(* - send messages only to valid objects     *)
(*                                           *)
(* Copyright 1995 Mike Ellis Software System *)
(*                                           *)
(*-------------------------------------------*)

Unit OValid;

Interface

Uses WinTypes,
     WinProcs,
     OWindows;

Function ValidObj(AnObj : PWindowsObject) : Boolean;
Function SendValidMsg(Rcvr : PWindowsObject; Msg, wParam : Word; lParam : LongInt) : Integer; 

Implementation

Function ValidObj(AnObj : PWindowsObject) : Boolean;
(*------------------------------------------------*)
Begin
   ValidObj := (AnObj <> Nil) And (AnObj^.HWindow <> 0);
End;

Function SendValidMsg(Rcvr : PWindowsObject; Msg, wParam : Word; lParam : LongInt) : Integer;
(*-----------------------------------------------------------------------------------------*)
Begin
   If ValidObj(Rcvr) Then SendValidMsg := SendMessage(Rcvr^.HWindow, Msg, wParam, lParam);
End;

End.   { Unit Initialization }

