(*-------------------------------------------*)
(*                                           *)
(* Unit to expand on OwlToolbar so that it   *)
(* sends "hints" to it's parent when the     *)
(* mouse pointer passes over a button.       *)
(*                                           *)
(* Copyright 1995 Mike Ellis Software System *)
(*                                           *)
(*-------------------------------------------*)

Unit OTbarHnt;

Interface

Uses WinTypes,
     WinProcs,
     OWindows,
     ToolBar,
     OValid;

Const
   am_ShowHint = wm_User + 300;

Type
   PHintButton =^THintButton;
   THintButton = OBject(TToolButton)
      Function GetEnabledCmd : Word;
   End;

   PHintToolbar = ^THintToolbar;
   THintToolbar = Object(TToolbar)
      HCmd : Word;
      Constructor Init(AParent : PWindowsObject; AName : PChar; Orient : Word);
      Function GetClassName : PChar; Virtual;
      Procedure WmMouseMove(Var Msg : TMessage); Virtual wm_First + wm_MouseMove;
      Procedure AmCalcParentClientRect(Var Msg: TMessage); Virtual wm_First + am_CalcParentClientRect;
   End;

Implementation

(*-------------*)
(* THintButton *)
(*-------------*)

Function THintButton.GetEnabledCmd : Word;
(*--------------------------------------*)
Begin
   If IsEnabled Then GetEnabledCmd := Command
   Else GetEnabledCmd := 0;
End;

(*--------------*)
(* THintToolbar *)
(*--------------*)

Constructor THintToolbar.Init(AParent : PWindowsObject; AName : PChar; Orient : Word);
(*----------------------------------------------------------------------------------*)
Begin
   Inherited Init(AParent, AName, Orient);
   HCmd := 0;
End;

Function THintToolbar.GetClassName : PChar;
(*---------------------------------------*)
Begin
   GetClassName := 'OwlHintToolbar';
End;

Procedure THintToolbar.WmMouseMove(var Msg : TMessage);
(*---------------------------------------------------*)
Var
   T : PTool;
   P : TPoint;
   R : TRect;
   Cmd : Word;

   Function IsHit(Item : PTool): Boolean; Far;
   (*---------------------------------------*)
   Begin
      IsHit := Item^.HitTest(P);
   End;

Begin
   Cmd := 0;                          { Assume nothing }
   P := TPoint(Msg.LParam);           { Mouse pointer position }
   GetClientRect(HWindow, R);         { Toolbar co-ords }
   If PtInRect(R, P) Then Begin       { Yes, on the toolbar }
      Inherited WmMouseMove(Msg);     { Let ancestor go first }
      If (GetCapture <> HWindow) Then SetCapture(HWindow);
      T := Tools.FirstThat(@IsHit);   { Are we on a Button? }
      If (T <> Nil) Then Cmd := PHintButton(T)^.GetEnabledCmd;
   End
   Else Begin                         { No, off the toolbar }
      If (GetCapture = HWindow) Then ReleaseCapture;  { Release mouse capture }
   End;
   If (Cmd <> HCmd) Then Begin        { Different command }
      HCmd := Cmd;                    { Save for next time }
      SendValidMsg(Parent, am_ShowHint, HCmd, 0); { Tell us about it }
   End;
End;

Procedure THintToolbar.AmCalcParentClientRect(Var Msg: TMessage);
(*-------------------------------------------------------------*)
Begin
   If IsWindowVisible(HWindow) Then Inherited AmCalcParentClientRect(Msg);
End;

End.   { Unit Initialization }

