(*---------------------------------------------*)
(*                                             *)
(* Unit to create an OwlStatusLine object that *)
(* is designed to be used in a TMdiWindow and  *)
(* will happily co-exist with an OwlToolBar.   *)
(*                                             *)
(* Copyright 1995 Mike Ellis Software System   *)
(*                                             *)
(*---------------------------------------------*)

Unit OStatLn;

Interface

Uses WinTypes,
     WinProcs,
     OWindows,
     ToolBar;

Type
   PStatusLine = ^TStatusLine;
   TStatusLine = Object(TWindow)
      StatusHeight : Word;
      Id : Word;
      S : Array [0..127] Of Char;
      Constructor Init(AParent : PWindowsobject);
      Procedure SetupWindow; Virtual;
      Function GetClassName: PChar; Virtual;
      Procedure GetWindowClass(Var AWndClass : TWndClass); Virtual;
      Procedure AmCalcParentClientRect(Var Msg : TMessage); Virtual wm_First + am_CalcParentClientRect;
      Procedure DisplayString(ResId : Word); Virtual;
      Procedure Paint(PaintDC : Hdc; Var PaintInfo : TPaintStruct); Virtual;
   End;

Implementation

Constructor TStatusLine.Init(AParent : PWindowsobject);
(*---------------------------------------------------*)
Begin
   Inherited Init(AParent, '');
   Attr.Style := ws_Child + ws_Visible + ws_border;
   Attr.X := 0;
   Attr.Y := 0;
   Attr.W := 0;
   Attr.H := 0;
   SetFlags(wb_MdiChild, False);
   Id := 0;
   S[0] := #0;
End;

Procedure TStatusLine.SetupWindow;
(*------------------------------*)
Var
   Dc : HDc;
   Tm : TTextMetric;

Begin
   Inherited SetupWindow;
   Dc := GetDc(HWindow);
   GetTextMetrics(Dc, Tm);
   StatusHeight := Tm.tmHeight + ((Tm.tmHeight Div 2) - 1);
   ReleaseDc(HWindow, Dc);
End;

Function TStatusLine.GetClassName: PChar;
(*-------------------------------------*)
Begin
   GetClassName := 'OwlStatusLine';
End;

Procedure TStatusLine.GetWindowClass(Var AWndClass : TWndClass);
(*------------------------------------------------------------*)
Begin
   Inherited GetWindowClass(AWndClass);
   AwndClass.hbrBackground := GetStockObject(LtGray_Brush);
End;

Procedure TStatusLine.AmCalcParentClientRect(Var Msg: TMessage);
(*-------------------------------------------------------------*)
var
   Cr : TRect;
   Nt : Integer;  { New top position }

Begin
   If IsWindowVisible(HWindow) Then Begin
      If Boolean(Msg.WParam) Then Begin  { Allowed to repaint window }
         Cr := PRect(Msg.LParam)^;       { Parent client rect }
         Nt := Cr.Bottom - StatusHeight; { Calcultae new top position }
         MoveWindow(HWindow, Cr.Left, Nt, Cr.Right, StatusHeight, True);
         Cr.Bottom := Nt;                { Remove our slice from client rect }
         SetRect(PRect(Msg.LParam)^, Cr.Left, Cr.Top, Cr.Right, Cr.Bottom);
      End;
   End;
End;

Procedure TStatusLine.DisplayString(ResId : Word);
(*----------------------------------------------*)
Var
   R : TRect;
   Dc : HDc;

Begin
   If (ResId <> Id) Then Id := ResID;             { New string to display }
   If (Id = 0) Then S[0] := #0                    { Clear old string } 
   Else LoadString(HInstance, Id, S, SizeOf(S));  { or Load from resource }
   Dc := GetDc(HWindow);
   GetClientRect(HWindow, R);
   FillRect(Dc, R, GetStockObject(LtGray_Brush)); { Redraw Window } 
   InflateRect(R, -2, -2);
   FrameRect(Dc, R, GetStockObject(Gray_Brush));  { 3D sculptured effect }
   SetBkMode(Dc, Transparent);
   ExtTextOut(Dc, 4, 2,eto_Clipped, @R, S, lstrlen(S), Nil);
   ReleaseDc(HWindow, Dc);
End;

Procedure TStatusLine.Paint(PaintDc : Hdc; Var PaintInfo : TPaintStruct);
(*---------------------------------------------------------------------*)
Begin
   DisplayString(Id);
End;

End.   { Unit Initialization }