VERSION 2.00
Begin Form frmCSetDemo 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "     Cats & Dogs                     |                   Control Sets Explorer"
   ClientHeight    =   5745
   ClientLeft      =   885
   ClientTop       =   1755
   ClientWidth     =   9090
   Height          =   6495
   Icon            =   CSETDEMO.FRX:0000
   Left            =   795
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   ScaleHeight     =   5745
   ScaleWidth      =   9090
   Top             =   1095
   Width           =   9270
   Begin ComboBox cboControlType 
      Height          =   300
      Left            =   6870
      Style           =   2  'Dropdown List
      TabIndex        =   33
      Top             =   3645
      Width           =   1590
   End
   Begin CheckBox chkNonMembers 
      Caption         =   "Use Set Non-Members (complement)"
      Height          =   345
      Left            =   4890
      TabIndex        =   32
      Top             =   3195
      Width           =   3615
   End
   Begin TextBox Text6 
      Height          =   930
      Left            =   1650
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   30
      Tag             =   "QBEHide;UserEnab=vet;FieldIdx=10;"
      Top             =   1755
      Width           =   2280
   End
   Begin Frame Frame2 
      Caption         =   "User Type"
      Height          =   945
      Left            =   5100
      TabIndex        =   26
      Top             =   390
      Width           =   1590
      Begin OptionButton optVet 
         Caption         =   "Vet"
         Height          =   210
         Left            =   255
         TabIndex        =   10
         Top             =   630
         Width           =   1005
      End
      Begin OptionButton optClerk 
         Caption         =   "Clerk"
         Height          =   210
         Left            =   255
         TabIndex        =   27
         Top             =   345
         Width           =   1005
      End
   End
   Begin ComboBox cboStatus 
      Height          =   300
      Left            =   1665
      Style           =   2  'Dropdown List
      TabIndex        =   24
      Tag             =   "QBEHide;FieldIdx=05;"
      Top             =   2745
      Width           =   1980
   End
   Begin TextBox Text5 
      Height          =   285
      Left            =   1665
      TabIndex        =   23
      Tag             =   "QBEHide;FieldIdx=04;"
      Top             =   1395
      Width           =   1755
   End
   Begin Frame Frame1 
      Caption         =   "Special Notes"
      Height          =   1485
      Left            =   240
      TabIndex        =   18
      Tag             =   "QBEHide;"
      Top             =   3450
      Width           =   3720
      Begin CheckBox Check2 
         Caption         =   "Rabies Certified"
         Height          =   255
         Left            =   1065
         TabIndex        =   35
         Tag             =   "AnimalVis=dog;FieldIdx=11;UserEnab=vet;"
         Top             =   990
         Width           =   2280
      End
      Begin CheckBox Check4 
         Caption         =   "Cat Nip Craving"
         Height          =   255
         Left            =   1065
         TabIndex        =   21
         Tag             =   "AnimalVis=cat;FieldIdx=08;"
         Top             =   675
         Width           =   1605
      End
      Begin CheckBox Check3 
         Caption         =   "Doggy Bone Delirum"
         Height          =   255
         Left            =   1065
         TabIndex        =   20
         Tag             =   "AnimalVis=dog;FieldIdx=09;"
         Top             =   690
         Width           =   2280
      End
      Begin CheckBox Check1 
         Caption         =   "Has Bitten!"
         Height          =   255
         Left            =   1065
         TabIndex        =   19
         Tag             =   "FieldIdx=07;"
         Top             =   345
         Width           =   1605
      End
   End
   Begin CommandButton cmdNext 
      Caption         =   ">"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   330
      Left            =   945
      TabIndex        =   17
      Tag             =   "Nav;"
      Top             =   5175
      Width           =   450
   End
   Begin CommandButton cmdPrev 
      Caption         =   "<"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   330
      Left            =   405
      TabIndex        =   16
      Tag             =   "Nav;"
      Top             =   5175
      Width           =   450
   End
   Begin CommandButton cmdQuery 
      Caption         =   "Query"
      Height          =   375
      Left            =   1725
      TabIndex        =   15
      Top             =   5130
      Width           =   1095
   End
   Begin TextBox Text4 
      Height          =   285
      Left            =   1665
      TabIndex        =   13
      Tag             =   "QBEHide;UserVis=vet;FieldIdx=06;"
      Top             =   3105
      Width           =   2220
   End
   Begin TextBox Text3 
      Height          =   285
      Left            =   1665
      TabIndex        =   11
      Tag             =   "FieldIdx=02;QBEYes;"
      Top             =   210
      Width           =   1755
   End
   Begin TextBox Text2 
      Height          =   285
      Left            =   1665
      TabIndex        =   9
      Tag             =   "QBEHide;FieldIdx=03;"
      Top             =   1035
      Width           =   1755
   End
   Begin TextBox txtOwner 
      Height          =   285
      Left            =   1665
      TabIndex        =   7
      Tag             =   "FieldIdx=01;QBEYes=0;"
      Top             =   690
      Width           =   1755
   End
   Begin CommandButton cmdSpeedTest 
      Caption         =   "Run Speed Test"
      Height          =   375
      Left            =   6810
      TabIndex        =   0
      Top             =   2775
      Width           =   1660
   End
   Begin ListBox lstEProperties 
      Height          =   1005
      Left            =   4890
      Sorted          =   -1  'True
      TabIndex        =   4
      Top             =   2100
      Width           =   1575
   End
   Begin ListBox lstDisplay 
      Height          =   1200
      Left            =   4695
      TabIndex        =   3
      Top             =   4425
      Width           =   4125
   End
   Begin CommandButton cmdTogVisible 
      Caption         =   "Toggle Enabled"
      Height          =   375
      Left            =   6810
      TabIndex        =   2
      Top             =   2340
      Width           =   1660
   End
   Begin CommandButton cmdTogEnabled 
      Caption         =   "Toggle Visible"
      Height          =   360
      Left            =   6810
      TabIndex        =   1
      Top             =   1935
      Width           =   1660
   End
   Begin Label Label13 
      Alignment       =   1  'Right Justify
      Caption         =   "Animal Name:"
      Height          =   285
      Left            =   255
      TabIndex        =   38
      Tag             =   "QBEYes=only;"
      Top             =   270
      Visible         =   0   'False
      Width           =   1230
   End
   Begin Shape Shape2 
      BorderColor     =   &H80000011&
      Height          =   960
      Left            =   1635
      Tag             =   "QBEHide;UserVis=clerk;"
      Top             =   1735
      Width           =   2315
   End
   Begin Label lblListCount 
      Alignment       =   1  'Right Justify
      Height          =   255
      Left            =   8385
      TabIndex        =   37
      Top             =   4170
      Width           =   425
   End
   Begin Line Line2 
      X1              =   4950
      X2              =   6755
      Y1              =   3960
      Y2              =   3960
   End
   Begin Label Label12 
      Caption         =   "Type       Txt          Val/Idx       ePropVal"
      Height          =   255
      Left            =   4725
      TabIndex        =   36
      Top             =   4200
      Width           =   3630
   End
   Begin Label Label11 
      Alignment       =   1  'Right Justify
      Caption         =   "Restrict to Ctl Type:"
      Height          =   255
      Left            =   4890
      TabIndex        =   34
      Top             =   3675
      Width           =   1830
   End
   Begin Label Label10 
      Alignment       =   1  'Right Justify
      Caption         =   "Exam Notes:"
      Height          =   180
      Left            =   60
      TabIndex        =   31
      Tag             =   "QBEHide;"
      Top             =   1830
      Width           =   1395
   End
   Begin Label Label9 
      Caption         =   "  Tweak Raw Control Sets       "
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   -1  'True
      Height          =   345
      Left            =   4665
      TabIndex        =   29
      Top             =   1500
      Width           =   3360
   End
   Begin Label Label4 
      Caption         =   "  Tweak App Logic        "
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   -1  'True
      Height          =   345
      Left            =   4635
      TabIndex        =   28
      Top             =   90
      Width           =   2385
   End
   Begin Line Line1 
      BorderColor     =   &H80000002&
      BorderWidth     =   2
      X1              =   4320
      X2              =   4320
      Y1              =   15
      Y2              =   6015
   End
   Begin Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "Life Style:"
      Height          =   195
      Left            =   90
      TabIndex        =   25
      Tag             =   "QBEHide;"
      Top             =   2805
      Width           =   1380
   End
   Begin Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "Last visit on:"
      Height          =   180
      Left            =   60
      TabIndex        =   22
      Tag             =   "QBEHide;"
      Top             =   1470
      Width           =   1395
   End
   Begin Label Label6 
      Alignment       =   1  'Right Justify
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   435
      Left            =   420
      TabIndex        =   14
      Tag             =   "FieldIdx=00;QBEHide;"
      Top             =   165
      Width           =   1065
   End
   Begin Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Breed:"
      Height          =   180
      Left            =   75
      TabIndex        =   12
      Tag             =   "QBEHide;UserVis=vet;"
      Top             =   3180
      Width           =   1395
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Weight:"
      Height          =   180
      Left            =   450
      TabIndex        =   8
      Tag             =   "QBEHide;"
      Top             =   1095
      Width           =   1020
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Owner:"
      Height          =   180
      Left            =   390
      TabIndex        =   6
      Tag             =   "QBEYes;"
      Top             =   750
      Width           =   1080
   End
   Begin Label Label2 
      Caption         =   "Pick a Set:"
      Height          =   285
      Left            =   4905
      TabIndex        =   5
      Top             =   1845
      Width           =   1590
   End
   Begin Shape Shape1 
      BorderColor     =   &H80000002&
      BorderWidth     =   3
      Height          =   5740
      Left            =   0
      Top             =   0
      Width           =   9070
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuEdit 
      Caption         =   "&Edit"
   End
   Begin Menu mnuCats 
      Caption         =   "&Cats"
      Tag             =   "AnimalEnab=cat;"
   End
   Begin Menu mnuDogs 
      Caption         =   "&Dogs"
      Tag             =   "AnimalEnab=dog;"
   End
End
Option Explicit

' Control Sets Explorer Application: "Cats & Dogs"
'
' by Roy Terry. Version 1.0, 9 July 1995; 
'
'
Dim theSet$        ' The set being tweaked/viewed

Const dataMax = 2
Dim AnimalData(dataMax) As String
Dim theRecIdx%

Const datasep = "^"

Const FI_Species = 0 'FieldIndex for cat/dog distinction

Sub cboControlType_Click ()
    If lstEProperties.ListIndex >= 0 Then lstEProperties_click
End Sub

Sub chkNonMembers_Click ()
    If lstEProperties.ListIndex >= 0 Then lstEProperties_click
End Sub

Sub cmdNext_Click ()
      'Mock UP
   goRecord theRecIdx + 1, True
End Sub

Sub cmdPrev_Click ()
      ' Mock Up
   goRecord theRecIdx - 1, True
End Sub

Sub cmdQuery_Click ()
      ' This code demonstrates more involved usage of CSets
      '
      ' Mockup a query-by-example. Hide
      ' irrelevant data and label controls.
      ' If something is already hidden then remember that fact
      ' and don't reveal it later (honor security)
      ' 
      ' Confession: Uses an embedded control name for
      '             query button itself

   Static oldvis() As Integer
   Dim stat%, cval$, i%, ctype%
   Dim setHide$, setShow$
   setHide = "QBEHide"
   setShow = "QBEYes"
   
   If cmdQuery.Caption = "Query" Then
         ' enter QBE "mode"
      AnimalData(theRecIdx) = Form2Record() ' save current data
      csetDisable Me, "nav"                 ' navigation buttons off
      csetVisibleInstr Me, setShow, "only"  ' show special QBE ctls


         ' Hide all most non-query controls but store
         ' their previous visibility to restore after query
      i = 0
      stat = csetFindFirst(Me, setHide, cval)
      ReDim oldvis(stat) 'stat is count on findfirst
      Do While stat
         oldvis(i) = csetControl.Visible
         i = i + 1
         csetControl.Visible = False
         stat = csetFindNext(Me, setHide, cval)
      Loop
      cmdQuery.Caption = "End Query"
            
            ' Clear text type queryable controls, set focus to
            ' control flagged with eProp value of 0
      stat = csetFindFirst(Me, setShow, cval)
      Do While stat
         If csetControlType(csetControl) = CT_TEXT Then
            csetControl = ""
            If cval = "0" Then csetControl.SetFocus
         End If
         stat = csetFindNext(Me, setShow, cval)
      Loop

   Else
         
         ' User is ending the query "mode"

         ' A light-weight query. For each Queryable control
         ' search corresponding field in the Animaldata. Find
         ' field by checking control's user input and Fieldidx
         ' and using that to extract datafield. Add/delete
         ' queryable controls and code keeps working
      Dim srchtxt$, fldTxt$, fi%, rec$
      stat = csetFindFirst(Me, setShow, cval)
      Do While stat
         If csetControlType(csetControl) = CT_TEXT Then
            srchtxt = Trim$(csetControl)
            fi = Val(csetQryCurrent(Me, "FieldIdx"))
            If Len(srchtxt) <> 0 Then
               For i = 0 To UBound(AnimalData)
                  rec = AnimalData(i)
                  fldTxt = csetGetStringField(rec, fi, datasep)
                  If InStr(1, fldTxt, srchtxt, 1) <> 0 Then
                     goRecord i, False        ' takes any hit
                     GoTo qryunhide
                  End If
               Next i
            End If
         End If
         stat = csetFindNext(Me, setShow, cval)
      Loop
      MsgBox "Sorry, not found", 64, "CSets"
      goRecord theRecIdx, False 'redraw current record
      
qryunhide:
         ' Now unwind UI from query "mode"
         
         ' Undo the hiding, but don't reveal things that
         ' started out hidden
      i = 0
      stat = csetFindFirst(Me, setHide, cval)
      Do While stat
         csetControl.Visible = oldvis(i)
         i = i + 1
         stat = csetFindNext(Me, setHide, cval)
      Loop
      cmdQuery.Caption = "Query"
      csetHideInStr Me, setShow, "only"   ' hide special QBE ctls
      csetEnable Me, "nav"                ' navigation buttons on
   End If
End Sub

Sub cmdSpeedTest_Click ()
   If Trim$(theSet) = "" Then
      MsgBox "Please pick a set for the speed test"
      Exit Sub
   End If
   
   Static cnt%, cntStr$
   If cnt = 0 Then
      cnt = 100
   End If
   Dim msg$, spd$, nl$
   msg = "How many Iterations?"
   cntStr = InputBox(msg, cmdSpeedTest.Caption, CStr(cnt))
   If cntStr = "" Then Exit Sub
   cnt = Val(cntStr)

   nl = Chr$(10)
   msg = nl
   msg = msg & nl & "=====Speed Test======"
   msg = msg & nl & "  Fetching "
   msg = msg & """" & theSet & """" & " " & cntStr & " times"
   msg = msg & nl & "  --Raw -----"
   spd = csetSpdRunTest(Me, theSet, "raw", cnt)
   msg = msg & nl & "    " & spd & "s"
   msg = msg & nl & "  --Cached --"
   spd = csetSpdRunTest(Me, theSet, "cache", cnt)
   msg = msg & nl & "    " & spd & "s"
   msg = msg & nl & "=====End Speed Test=="
   
   Debug.Print msg
   MsgBox msg, 0, cmdSpeedTest.Caption
End Sub

Sub cmdTogEnabled_Click ()
   Dim v$, s%
      'invert the visible property for the set
   s = csetFindFirst(Me, theSet, v)
   Do While s
         ' Work around: VB gives runtime error on "Exit" submenu
         ' control, seemingly because it's the one and only
         ' item below "File"
         If csetControlType(csetControl) = CT_MENU Then
            If csetControl.Caption = "E&xit" Then
               GoTo hideSkip
            End If
         End If
         If TypeQualify(csetControl) Then
            csetControl.Visible = (Not csetControl.Visible)
         End If
hideSkip:
      s = csetFindNext(Me, theSet, v)
   Loop
End Sub

Sub cmdTogVisible_Click ()
   Dim v$, s% ' value and status

   s = csetFindFirst(Me, theSet, v)
   Do While s
      If TypeQualify(csetControl) Then
         csetControl.Enabled = (Not csetControl.Enabled)
      End If
      s = csetFindNext(Me, theSet, v)
   Loop

End Sub

Sub Form_Load ()
   csetSetSortList frmUtility.lstSort 'need this initial step
      
      ' init control types list for tweakers
   Dim c As Control
   Set c = cboControltype
   c.AddItem "All Types"
   c.AddItem "List"
   c.AddItem "Combo"
   c.AddItem "Text"
   c.AddItem "Label"
   c.AddItem "Check"
   c.AddItem "Cmd"
   c.AddItem "Grid"
   c.AddItem "Option"
   c.AddItem "Menu"
   c.AddItem "Frame"
   c.AddItem "Shape"
   c.ListIndex = 0
   

   lstEProps
   InitMockUpdata
   optClerk = True
   goRecord 0, False
End Sub

Sub Form_Unload (cancel As Integer)
End
End Sub

Function Form2Record$ ()
   ' 
   ' Read all data-bearing fields, build a new record string
   ' and assign it to the mock data array
   ' Note: for demo purposes ignores usual concerns with
   '       cancel, undo, etc.
   Dim stat%, propv$, dat$, aRec$
   Dim propName$: propName = "FieldIdx"

      ' loop thru field index building up a rec.
      ' Depends on proper sorting of
      ' returned controls
   stat = csetFindFirst(Me, propName, propv)
   Do While stat
      Select Case csetControlType(csetControl)
          Case CT_COMBO
               ' combo data is index
            dat = Format$(csetControl.ListIndex)
         Case CT_TEXT, CT_LABEL
            dat = csetControl
         Case CT_CHECK
               'Check boxes adopt 1/0 values
            dat = Format$(csetControl)
      End Select
         ' add a field
      If Len(aRec) = 0 Then
         aRec = dat
      Else
         aRec = aRec & datasep & dat
      End If
      stat = csetFindNext(Me, propName, propv)
   Loop
   Form2Record = aRec
End Function

Sub goRecord (idx%, savePrev%)
      ' Change record or restore current  
      ' Honor data sensitive settings (ie. Cat/Dog)
   
   If idx < 0 Or idx > dataMax Then Exit Sub  'sanity

   If savePrev Then
         ' copy form data to catch changes if any
      AnimalData(theRecIdx) = Form2Record()
   End If
   
   theRecIdx = idx

      'based on the new animal type,
      'set visibility and enabling as needed
   Dim at$ ' Animal Type
   at = csetGetStringField(AnimalData(idx), FI_Species, datasep)
   csetSyncVisibleInstr Me, "AnimalVis", at
   csetSyncEnableInstr Me, "AnimalEnab", at
   
   ShowRecord Me, AnimalData(idx)
End Sub

Sub InitMockUpdata ()
   cboStatus.AddItem "Pet"
   cboStatus.AddItem "Personal Assist"
   cboStatus.AddItem "Commercial"
   cboStatus.AddItem "Show"
   
   Dim d$
   d = "Dog^Jones, Mike^Bogart^35^18 March 1995^0"
   d = d & "^Irish Setter^0^0^0"
   d = d & "^One sick puppy. Prescribed napping on couch^1"
   AnimalData(0) = d
   
   d = "Cat^Bunker, Bridgette^Punky^11^1 June 1995^0"
   d = d & "^Persian $iamese^0^1^0"
   d = d & "^Depression. This cat needs excitement. "
   d = d & "Recommend nights out.^0"
   AnimalData(1) = d
   
   d = "Dog^Acme Protection^Growler^65^31 April 1995^2"
   d = d & "^Doberman Pinscher^1^0^0"
   d = d & "^Nervous. Needs more playtime with dog friends.^1"
   AnimalData(2) = d

End Sub

Sub listcontrols ()
      'Make a 4 column display based on global: "theSet"
      ' <ctltype> <ctl txt> <ctl "value"> <ePropValue>
   Dim ctltype$, ctlTxt$, ctlData$, ct%
   Dim v$, s%
   Dim t$: t = Chr$(9)  ' a tab

   lstDisplay.Clear
   s = csetFindFirst(Me, theSet, v)
   Do While s
      ct = csetControlType(csetControl)
      If TypeQualify(csetControl) Then
         If ct > 0 And ct < cboControltype.ListCount Then
            ctltype = cboControltype.List(ct)
            Select Case ct
               Case CT_CMD, CT_CHECK, CT_OPTION, CT_MENU
                  ctlData = "  v=" & CStr(csetControl)
                  ctlTxt = csetControl.Caption
               Case CT_LABEL
                  ctlData = "  -" ' none
                  ctlTxt = csetControl.Caption
               Case CT_LIST, CT_COMBO
                  ctlTxt = csetControl
                  ctlData = "  i=" & csetControl.ListIndex
               Case CT_TEXT
                  ctlData = "  -" ' none
                  ctlTxt = csetControl
               Case CT_GRID
                  ctlTxt = csetControl
                  ctlData = "  -"
               Case CT_SHAPE
                  ctlTxt = "-"
                  ctlData = "  s=" & csetControl.Shape
            End Select
         Else
            ctltype = "???"
            ctlTxt = "-"
         End If
         Dim msg$
         msg = ctltype & t & Left$(ctlTxt, 7) & t
         msg = msg & Left$(ctlData, 8) & t & theSet & "=" & v
         lstDisplay.AddItem msg
      End If
      s = csetFindNext(Me, theSet, v)
   Loop
   lblListCount = Format$(lstDisplay.ListCount)
End Sub

Sub lstEProperties_click ()
   If chkNonMembers Then
      theSet = "<>" & lstEProperties
   Else
      theSet = lstEProperties
   End If
   listcontrols
End Sub

Sub lstEProps ()
      'List all the properties on all controls of the
      ' form
   Dim i%, j%, cnt%, p$, eProps$, allEprops$, t$
   
   lstEProperties.Clear
   allEprops = ","
   For i = 0 To controls.Count - 1
      t = controls(i).Tag
      If t = "" Then GoTo nxtI
      eProps = csetEPropNamesExtract(t, cnt)
         'loop thru and ignore dups
      For j = 0 To cnt
         p = csetGetStringField(eProps, j, ",")

         If InStr(1, allEprops, "," & p & ",", 1) Then
            GoTo nxtJ
         End If
         allEprops = allEprops & "," & p
         lstEProperties.AddItem p
nxtJ:
      Next j
      allEprops = allEprops & ","
nxtI:
   Next i
End Sub

Sub mnuFileExit_Click ()
   Unload Me
   End
End Sub

Sub optClerk_Click ()
   userChange "clerk"
End Sub

Sub optVet_Click ()
   userChange "vet"
End Sub

Sub ShowRecord (frm As Form, rec$)
      ' Mock Up
      'Refresh forms data based on EProp, no use of control names

   Dim s%, propv$, fld$, t$, ds$
   Dim propName$: propName = "FieldIdx"
   ds = datasep
   s = csetFindFirst(frm, propName, propv)
   Do While s
      Select Case csetControlType(csetControl)
          Case CT_COMBO
               ' do a selection, the EProp tells which field
          fld = csetGetStringField(rec, CInt(propv), ds)
          csetControl.ListIndex = Val(fld)
         Case CT_TEXT, CT_LABEL
            t = csetGetStringField(rec, CInt(propv), ds)
            csetControl = t
         Case CT_CHECK
               'Check boxes adopt 1/0 values
            t = csetGetStringField(rec, CInt(propv), ds)
            csetControl = Val(t)
      End Select
      s = csetFindNext(frm, propName, propv)
   Loop

End Sub

Function TypeQualify% (c As Control)
      Dim ctype%, ctChoice%
      ctype = csetControlType(c)
      ctChoice = cboControltype.ListIndex
      TypeQualify = (ctChoice = 0 Or ctChoice = ctype)
End Function

Sub userChange (usertype$)
      ' Mock Up
   csetSyncVisibleInstr Me, "UserVis", usertype
   csetSyncEnableInstr Me, "UserEnab", usertype
End Sub

