Option Explicit
Option Compare Text

' Control Sets Implementation
'
' by Roy Terry. Version 1.0, 9 July 1995;
'
' This module facilitates using the "object" features
' of visual basic by providing quick lookup for
' objects of type control based on form and on Extended
' control properties string which is formatted
' thusly: name=val;name2=val2;... The string is assigned to the
' tag property of each relevant control.

' EProperties are expected to be static
' once the form has been shown during a session and probably
' statically set at development time.
'
' Caches are created automatically on first call into the service.
'
' DATA STRUCTURE
' Maintains parallel arrays which
' grow in linked fashion each time a new
' form/eprop combination is cached: E.g., when caching a new eprop
' for form f1, assuming 11 controls have the property set, then
' 1 new record slot will be allocated and 11 new control array
' slots will be allocated. Similar two-part structure for raw
' tag strings on form-by-form basis
'
' Private routines have "_" in their name
'
'


    ' --- Principal Data Structures for CSets Cache ---

Const CS_MAXCTLS = 50      ' in a particular set

Type CtlPropInfo
   propVal(CS_MAXCTLS) As String    ' store each value, can't redim
   formId As Long          ' keypart1 - the hWnd, (long for win32)
   propName As String      ' keypart2
                           ' indexes into csetControls()...
   fstidx As Integer       '       first valid
   curIdx As Integer       '       last fetched
   lstidx As Integer       '       last valid
End Type

Dim csetRecCount%          ' how many sets cached
Dim csetCtlCount%          ' how many pointers to controls cached
Dim csetRecs() As CtlPropInfo
Dim csetControls() As Control

   ' --- cache-within-cache stores last set accessed ---
Type csetPrevSet
   formId As Long
   propName As String
   csetIdx As Integer       ' into csetRecs
End Type

Dim csetPrev As csetPrevSet
Dim csetPrevForm As Form     ' special case form obj ptr for speed


   ' --- Form-by-form caching of raw tag strings ---
Type FormTagInfo
   formId As Long
   fstidx As Integer
   lstidx As Integer
End Type

Dim csetTagInfo() As FormTagInfo
Dim csetTaginfoTotal%

Dim csetTagStrings() As String
Dim csetTagTotal%

    ' --- Miscellaneous ---
Global csetControl  As Control  ' "returned" from first/next calls
Dim csetSortList As ListBox     ' Sorting. Caller must set this!
Const nonMemberPrefix = "<>"    ' How CSets get complemented
Dim csetInitFlag%               ' Module initialization flag

Private Sub cset_GetTagsForForm (frm As Form, tagFst%, tagLst%)
      ' Return access indexes for frm's tag strings
      ' read them if necessary.
   Dim i%, iInf%, fid&, tcnt%
   fid = frm.hWnd
   For iInf = 0 To UBound(csetTagInfo)
      If fid = csetTagInfo(iInf).formId Then
            ' tags already read, just return location
         GoTo gtfReturnValues
      End If
   Next iInf

      'cache the form's tags
   
   tcnt = frm.Controls.Count
   ReDim csetTagStrings(UBound(csetTagStrings) + tcnt)
   ReDim csetTagInfo(UBound(csetTagInfo) + 1)
   csetTagInfo(csetTaginfoTotal).formId = fid
   csetTagInfo(csetTaginfoTotal).fstidx = csetTagTotal
   For i = 0 To tcnt - 1
      csetTagStrings(csetTagTotal) = frm.Controls(i).Tag
      csetTagTotal = csetTagTotal + 1
   Next i
   csetTagInfo(csetTaginfoTotal).lstidx = csetTagTotal - 1
   
   iInf = csetTaginfoTotal
   csetTaginfoTotal = csetTaginfoTotal + 1

gtfReturnValues:
   tagFst = csetTagInfo(iInf).fstidx
   tagLst = csetTagInfo(iInf).lstidx

End Sub

Private Function cset_ScanForSet% (frm As Form, ByVal eprop$, val0$)
      ' Scan the form for members of the set defined by "eprop"
      ' Sort the result by eProp value and install into the
      ' csetRecord and csetControl arrays
      ' RETURN Count of controls found
      ' Uses listbox for sorting,

      ' This is the core of CSets functionality

      
      
   ReDim ctlTemp(CS_MAXCTLS) As Integer  ' facilitates sorting
   Dim i%, ctlI%, cval$, s$, aTab$
   Dim hitI%
   aTab = Chr$(9)

   If csetSortList Is Nothing Then
       MsgBox "Sorry, csetFindFirst needs csetSetSortList() first"
       cset_ScanForSet = 0
       Exit Function
   End If
      
      ' Set Complement is implemented by special propName prefix
   Dim nonMember$
   If Left$(eprop, Len(nonMemberPrefix)) = nonMemberPrefix Then
      nonMember = nonMemberPrefix
      eprop = Mid$(eprop, Len(nonMemberPrefix) + 1)
   Else
      nonMember = ""
   End If
   
      
      ' Get access indexes to scan tag strings of controls on "frm"
   Dim tagFst%, tagLst%
   cset_GetTagsForForm frm, tagFst, tagLst

      ' Scan the form, copy *value* of each member to sorted
      ' listbox with lookup index for later retrieval
   csetSortList.Clear
   hitI = 0
   For i = tagFst To tagLst
      cval = csetGetEPropValue(csetTagStrings(i), eprop)
      If nonMember = nonMemberPrefix Then
             ' Nonmembers means the value will be empty
             ' assign a value of "1" to the nonmember eprop
         If cval = "" Then
            cval = "1"
            GoTo sfsAddIt
         End If
      Else
         If cval <> "" Then
sfsAddIt:
            ctlTemp(hitI) = i - tagFst
            s = cval & aTab & hitI
            csetSortList.AddItem s
            hitI = hitI + 1
         End If
      End If
   Next i
   

     ' If NO controls have the given property get out
   If hitI = 0 Then cset_ScanForSet = 0: Exit Function

      'Setup a new range of values in the cache
   ReDim Preserve csetRecs(UBound(csetRecs) + 1)
   ReDim Preserve csetControls(UBound(csetControls) + hitI)
   
   csetRecs(csetRecCount).fstidx = csetCtlCount
   csetRecs(csetRecCount).curIdx = csetCtlCount
   csetRecs(csetRecCount).propName = nonMember & eprop
   csetRecs(csetRecCount).formId = frm.hWnd

   For i = 0 To hitI - 1
         ' get them back sorted on value
      s = csetSortList.List(i)
      cval = csetGetStringField(s, 0, aTab)
      If Left$(cval, 2) Like "&[HhOo]" Then 'honor hex/oct
         cval = Format$(cval)
      End If
      csetRecs(csetRecCount).propVal(i) = cval
      ctlI = ctlTemp(Val(csetGetStringField(s, 1, aTab)))
      Set csetControls(csetCtlCount) = frm.Controls(ctlI)
      csetCtlCount = csetCtlCount + 1
   Next i
   csetRecs(csetRecCount).lstidx = csetCtlCount - 1

      ' Cache is all setup - now "return" 3 parts:
      ' - value of first found
      ' - Control itself (in global)
      ' - the count of controls in this set

   val0 = csetRecs(csetRecCount).propVal(0)       ' first

   Set csetControl = csetControls(csetRecs(csetRecCount).fstidx)

   Dim c%: c = csetRecCount
   cset_ScanForSet = 1 + (csetRecs(c).lstidx - csetRecs(c).fstidx)
   
   Set csetPrevForm = frm              ' fast find on try for next
   cset_SetPrev csetRecCount          '   "    "
   
   csetRecCount = csetRecCount + 1   ' ready for next set

End Function

Private Function cset_Search% (frm As Form, eprop$)
   ' Scan cache for the passed set
   ' If found, return: index, else return: -1

   Dim fid&, i%
      
      ' Skip the search if this is the last pair we searched for
      ' Note that we compare frm NOT frm.hWnd because .hWnd is
      ' expensive to access
   If frm Is csetPrevForm Then
      If csetPrev.propName = eprop Then
          cset_Search = csetPrev.csetIdx
          Exit Function
      End If
   End If
   fid = frm.hWnd          ' This is a sloooow operation
      
      'Scan the cache
   For i = 0 To UBound(csetRecs)
      If csetRecs(i).formId = fid Then
          If csetRecs(i).propName = eprop Then
               ' Found a range in cache dedicated to requrested
               ' set
               ' Rember this set for next time
               ' Return position of its rec structure
              Set csetPrevForm = frm 'save fetching .hWnd on "next"
              cset_SetPrev i
              
              cset_Search = i
              Exit Function
          End If
      End If
   Next i
   cset_Search = -1
End Function

Private Sub cset_SetPrev (i%)
      ' cache last frm/eprop index used to speedup iteration
   csetPrev.formId = csetRecs(i).formId
   csetPrev.propName = csetRecs(i).propName
   csetPrev.csetIdx = i
End Sub

Function csetFindFirst% (frm As Form, ByVal eprop$, pval$)
      '
      ' Principal CSets routine.
      ' User wants to iterate controls on "frm"
      ' in the set "eprop"
      '
      ' OUTPUTS: csetControl (global) refers to first control in set
      '          pVal is set to first controls eprop value
      '          returns Number of controls in set
      '
      ' Set "current" position to support csetFindNext()
      '
      ' Side Effects:
      '     - cache tags strings of form if not already done
      '     - cache the "eprop" set if not already done
      '
      ' Must be called before next,qry functions will work

   Dim i%, fstI%, ctlCount%
   
   If csetInitFlag = 0 Then
          ' Initialize module cache arrays
      ReDim csetControls(0)
      ReDim csetRecs(0)
      ReDim csetTagInfo(0)
      ReDim csetTagStrings(0)
      csetInitFlag = 1
   End If

      'Is requested CSet in the cache already?
   i = cset_Search(frm, eprop)
   If i >= 0 Then
         ' Set found;  return first one and record position
      fstI = csetRecs(i).fstidx
      csetRecs(i).curIdx = fstI
      Set csetControl = csetControls(fstI)
            'propval(0) corresponds to csetControls(fstI)
      pval = csetRecs(i).propVal(0)
      csetFindFirst = 1 + (csetRecs(i).lstidx - csetRecs(i).fstidx)
      Exit Function
   End If

      ' There are no entries for the
      ' set in the cache.  Scan for them.
   csetFindFirst = cset_ScanForSet(frm, eprop, pval)
End Function

Function csetFindFirstNonMember% (frm As Form, ByVal eprop$, pval$)
   Dim r%
   r = csetFindFirst(frm, nonMemberPrefix & eprop, pval)
   csetFindFirstNonMember = r
End Function

Function csetFindNext% (frm As Form, ByVal eprop$, pval$)
      ' Return the next control on form "frm" with property "eprop"
      ' see csetFindFirst
   Dim i%
   If csetInitFlag = 0 Then csetFindNext = False: Exit Function
      
      ' Do we have frm/eprop in cache?
   i = cset_Search(frm, eprop)
   If i < 0 Then csetFindNext = False: Exit Function
      
      ' has caller already fetched last entry?
   If csetRecs(i).curIdx = csetRecs(i).lstidx Then
       csetFindNext = False
       Exit Function
   End If
      
      ' Advance, "returning" the controls value for the EProp,
      ' the control, and TRUE
   csetRecs(i).curIdx = csetRecs(i).curIdx + 1
   Dim PropI%
   PropI = csetRecs(i).curIdx - csetRecs(i).fstidx
   pval = csetRecs(i).propVal(PropI)
   Set csetControl = csetControls(csetRecs(i).curIdx)
   csetFindNext = True
End Function

Function csetFindNextNonMember% (frm As Form, ByVal eprop$, pval$)
    Dim r%
    r = csetFindNext(frm, nonMemberPrefix & eprop, pval)
    csetFindNextNonMember = r
End Function

Function csetQryControl$ (frm As Form, eprop$, ctl As Control)
      ' If control has qry'd eprop return its value, else return ""
      ' We do not require that caller has done a findfirst on
      ' the Qry'd-for set. This means doing it ourselves
      ' if need be
      ' This routine can be called before csetFindFirst if
      ' desired

   Dim iInfo%, iCtls%, s%, junk$
      ' if not inited get inited
   If csetInitFlag = 0 Then
      s = csetFindFirst(frm, eprop, junk)
      If Not s Then Exit Function
   End If

   Dim saveCpc As Control: Set saveCpc = csetControl
   iInfo = cset_Search(frm, eprop)
   If iInfo < 0 Then
      If Not s Then  ' didn't try for this eprop above
         s = csetFindFirst(frm, eprop, junk)
         If Not s Then
            Set csetControl = saveCpc
            Exit Function
         Else
            iInfo = cset_Search(frm, eprop) ' now guaranteed
         End If
      End If
   End If

       ' Scan the set looking for the passed ctl pointer
       ' if found return the corresponding eProp value
   For iCtls = csetRecs(iInfo).fstidx To csetRecs(iInfo).lstidx
      If csetControls(iCtls) Is ctl Then
         Dim PropI%
         PropI = iCtls - csetRecs(iInfo).fstidx
         csetQryControl = csetRecs(iInfo).propVal(PropI)
         Set csetControl = saveCpc
         Exit Function
      End If
   Next iCtls
   Set csetControl = saveCpc
End Function

Function csetQryCurrent$ (frm As Form, eprop$)
   csetQryCurrent = csetQryControl(frm, eprop, csetControl)
End Function

Sub csetSetSortList (l As ListBox)
   Set csetSortList = l  ' let calling program give us a listbox
End Sub

Sub csetSpaceUsage ()
      ' Rough Report of cache space consumption to debug window
   Dim i%, j%, jmax%, tot%, stot%, setmax%
   For i = 0 To UBound(csetTagStrings)
      tot = tot + 4 + Len(csetTagStrings(i))
   Next i
   tot = tot + (UBound(csetTagInfo) * 8)
   Debug.Print "RawTags " & UBound(csetTagStrings) & " Strings"
   Debug.Print "        " & tot & " bytes"

      'Tally up string contents and control pointers space usage
   stot = tot
   tot = 0
   For i = 0 To UBound(csetRecs)
      jmax = csetRecs(i).lstidx - csetRecs(i).fstidx
      If jmax > setmax Then setmax = jmax
      For j = 0 To jmax
            ' 4 bytes for control pointer + len of eProp value
         tot = tot + 4 + Len(csetRecs(i).propVal(j))
      Next j
   Next i
      ' add in string overhead of four bytes even if not used
   tot = tot + (UBound(csetRecs) * 4 * CS_MAXCTLS)
   Debug.Print "CSets   " & UBound(csetRecs) & " sets";
   Debug.Print ", most members: " & setmax
   Debug.Print "        " & tot & " bytes"
   Debug.Print "Total: " & tot + stot & " bytes"
End Sub

Function csetGetEPropValue$ (ByVal Tag$, ByVal prop$)
   ' Search of string of name/value pairs in 
   ' following format:
   '      [;]<propName>[=value][;<prop2Name>[=value] ...
   ' If value is empty return "1"
   ' If name not found return ""
   ' Case INsensitive
   '
   ' This routine not private 'cause it may be handy in other
   ' contexts, such as looking at FORM level tags.
   ' Speed can no doubt be improved
   
   Dim i%, j%, nxt$
   Dim v, x As String

   ' Two cases: prop is first, prop is not first. This done so that
   ' we needn't require a leading ';' on the tag
   j = 1
geRepeat:
   i = InStr(j, Tag, prop, CASEIGNORE)

   If i = 0 Then v = "": GoTo geGetout

   If i <> 1 Then
      If Mid$(Tag, i - 1, 1) <> ";" Then

            ' recheck in case prop name embedded in 2nd propname
          j = i + 1: GoTo geRepeat
      End If
   End If
   i = i + Len(prop)
   nxt = Mid$(Tag, i, 1)
   Select Case nxt
      Case ";", ""
         v = "1": GoTo geGetout 'begin next prop / end of string
      Case "="
         i = i + 1              ' point to value
      Case Else
         j = i + 1: GoTo geRepeat
   End Select
      ' Get the value; it ends with either ';' or end of tag string
   v = ""
   Do
      x = Mid$(Tag, i, 1) ' one char at a time
      If Len(x) = 0 Or x = ";" Then Exit Do
      v = v & x
      i = i + 1
   Loop While True

geGetout:
   csetGetEPropValue = v
End Function
