//Listing 4. Execute methods for the action classes.

void Literal_number::execute()
{
  expr_stack.push(atoi((char *)param_block);
}

void Variable_value::execute()
{
  curr_value =
    symbol_table.get_variable_value((char *)param_block);
  expr_stack.push(curr_value);
}

void Add_operation::execute()
{
  curr_value = expr_stack.pop() + expr_stack.pop();
  expr_stack.push(curr_value);
}

void Function_call::execute()
{
  num_passed_arguments = (int)param_block;
  param_block += sizeof(int);
  symbol_name = (char *)param_block;
  //the execute_function method pops the number of arguments
  //  specified by num_passed_arguments
  curr_value =
    symbol_table.execute_function(symbol_name, num_arguments);
  expr_stack.push(curr_value);
}

void Asignment::execute()
{
  curr_value = expr_stack.pop();
  symbol_name = (char *)param_block;
  symbol_table.set_variable_value(symbol_name, curr_value);
}

void Display_value::execute()
{
  curr_value = expr_stack.pop();
  cout << curr_value << endl;
}
