/*  XDIR.CMD A REXX utility.  This program calls the REXX external
 function in the file FILEDATE.DLL.  It is an expanded directory
 function, displaying each file in the directory specified,
 including hidden and system files, along with the subdirectories
 contained in that file.  It will display files with long names, if
 reading an HPFS directory.
    Output format:  The name of the directory, followed by one line
 per included file.
    Each line displays:
       The "last-written-to" date, in mm/dd/yyyy format
       The "last=written-to" time, in 12-hour format
       The length of the file, in bytes
       The length of EAs associated with the file, in bytes
       The file attributes
       The name of the file (upper case) as shown in the directory
*/
    Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    Call 'SysLoadFuncs'
    arg filename
/* Set up for directory (or individual filename); abort if named
*     drive is not on the system:
*/
    oldir = translate(directory())   /* Force to upper case */
    if substr(filename,2,1) = ":" then do
        if left(filename,2) \= left(oldir,2) then ,
            newdir = translate(directory(left(filename,2)))
        if newdir = "" then do
            say "Directory" left(filename,2) "not FOUND " ,
                 "- terminating program"
            return
            end /* if newdir... */
        end /* if substr... */
    prefix = translate(directory())    /* New current directory */
    if right(prefix,1) \= "\" then prefix = prefix"\"
/* Note:  Only root directory names have closing "\" symbols */
    if substr(filename,2,1) = ":" then ,
        if length(filename) = 2 then filename = prefix
    if pos(":",filename) = 0 then do
        if left(filename,1) = '\' then ,
            filename = prefix||substr(filename,2)
        else filename = prefix||filename
        end /* if pos... */
/* Note:  "filename" variable now includes directory and path */
    if right(filename,1) = '\' then filename = filename'*.*'
    else filename = filename'\*.*'
/* Note:  The following loop takes care of the case when "filename"
*    refers to a single file, not a directory:
*/
    do while lastpos('\*.*',filename) \= 0
        if block = 'OK' then ,
        filename = left(filename,length(filename) - 4)
        else block = 'OK'
        call SysFileTree filename, files, 'B'
        if files.0 \= 0 then leave
        end /* do while */
/* We could have gotten here in one of two ways; let's check:
*/
    if files.0 = 0 then do
        say "   " filename "not found - terminating program"
        call directory oldir    /* Return to original directory */
        return
        end /* if files */
/* Found something!  So display it [them]
*/
    call RxFuncAdd 'FileDate', 'FILEDATE', 'FileDate'
    if (lastpos('\',filename) \= 0) then,
        directory = left(filename,lastpos('\',filename))
    else directory = directory()  /* Safety net! Shouldn't occur. */
    call 'SysCls'
    say
    say "Directory of:" directory
    say
    say " FileDate " "FileTime" "FileLength" " EALength ",
            "Attributes" "    File"
    say 
    do i = 1 to files.0
         parse value files.i with . filetime filelen attrib filespec
         filespec = substr(filespec,2)   /* delete leading <sp> */
         call 'FileDate' filespec
         parse var result lastwrote EAs filetitle
         if substr(attrib,2,1) = "D" then filelen = "<DIR>"
         say right(lastwrote,10) ' 'right(filetime,6) ,
             right(filelen,10) right(EAs,10) center(attrib,14) ,
             translate(filetitle)
         end /* do */
    call directory oldir
    return
