// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "DROP1.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_DROPFILES()
	ON_WM_QUERYOPEN()
	ON_WM_SYSCOMMAND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// Grab a handle to our system menu and delete "Restore" and "Maximize"  
	CMenu *sysmenu = GetSystemMenu(FALSE);
	sysmenu->DeleteMenu(SC_RESTORE,MF_BYCOMMAND);
	sysmenu->DeleteMenu(SC_MAXIMIZE,MF_BYCOMMAND);

	// Tell Windows that we're open for DND business
	DragAcceptFiles(TRUE);
	
	return 0;
}

void CMainFrame::OnDropFiles(HDROP hDropInfo) 
{
    char file_buffer[MAX_PATH];
	UINT num_files, i;

    // Get the number of dropped files from Windows
	num_files = DragQueryFile(hDropInfo,0xffffffff,file_buffer,sizeof(file_buffer));

    // Now retrieve names and process each one
	for(i = 0; i < num_files; i++)
	  {
	    DragQueryFile(hDropInfo,i,file_buffer,sizeof(file_buffer));
		ProcessDroppedFile(file_buffer);
	  } 

    // Tell Windows we're done with the DND operation
    DragFinish(hDropInfo); 
}

BOOL CMainFrame::OnQueryOpen() 
{
	// We always refuse to run as anything but a minimized program
	return FALSE;
}

// Do something visible with a filename.  Note the advanced AI algorithm.
void CMainFrame::ProcessDroppedFile(char * fn)
{
  MessageBox(fn,"Dropped file:",MB_OK);
}


void CMainFrame::OnSysCommand(UINT nID, LPARAM lParam) 
{
    UINT the_real_nID = nID & 0xFFF0;

    // Swallow these system commands, even though we respond FALSE to a
    // WM_QUERYOPEN message.  See chapter 8 for details.
    if((the_real_nID == SC_RESTORE) || (the_real_nID == SC_MAXIMIZE))
      return;

	CFrameWnd::OnSysCommand(nID, lParam);
}
