// DIB Object for MFC -- Williams
#ifndef _CDIB_H
#define _CDIB_H


#include <afxwin.h>
#include "dibapi.h"

class CDib : public CObject
  {
  protected:
    HDIB dibhandle;      // base HDIB
    CPalette *palette;   // palette cache
    LPSTR lockptr;       // pointer cache
    LPSTR Lock(void) {   // Get pointer
      return lockptr?
        lockptr:
        (lockptr=(LPSTR)GlobalLock(dibhandle));
        };
    void SetPalette(void) {  // Get palette
       if (palette) return;
       palette=new CPalette;
       palette->Attach(::CreateDIBPalette(dibhandle));
       };
  public:
// phase 1 constructor
    CDib() {
      palette=NULL;
      lockptr=NULL;
      dibhandle=NULL;
      };

// phase 2 "constructors" only call once!
// create from bitmap
    BOOL Create(CBitmap *bitmap,CPalette *pal) {
      dibhandle=BitmapToDIB((HBITMAP)bitmap->m_hObject,
        (HPALETTE)pal->m_hObject);
        return dibhandle!=NULL;
      };
// Create from screen
    BOOL Create(LPRECT screen) {
      dibhandle=::CopyScreenToDIB(screen);
      return dibhandle!=NULL;
      };
// Create from window
    BOOL Create(CWnd *w,WORD area) {
      dibhandle=::CopyWindowToDIB(w->m_hWnd,area);
      return dibhandle!=NULL;
      };
// create empty
    BOOL Create(unsigned w,unsigned h,unsigned bits) {
      dibhandle=::CreateDIB(w,h,bits);
      return dibhandle!=NULL;
      };
// load from file
    BOOL Create(LPSTR file) {
      dibhandle=::LoadDIB(file);
      return dibhandle!=NULL;
      };
// Copy DIB and convert
    BOOL Create(CDib *dib,WORD bits,DWORD comp) {
      dibhandle=::ChangeDIBFormat(dib->dibhandle,bits,comp);
      return dibhandle!=NULL;
      };

// Destructor
    virtual ~CDib() {
      if(lockptr) GlobalUnlock(dibhandle);
      if (palette) delete palette;
      if(dibhandle) DestroyDIB(dibhandle);
      };

// Do error message (static)
    static void ErrorMessage(int no) { ::DIBError(no); };

// Get palette
    CPalette *GetPalette(void) {
      SetPalette();
      return palette;
      };

// Paint DIB
    WORD Paint(CDC *dc,LPRECT r1,LPRECT r2,CPalette *pal) {
      return ::PaintDIB(dc->m_hDC,r1,dibhandle,r2,
        pal?(HPALETTE)pal->m_hObject:NULL);
      };

// Print DIB
    WORD Print(LPSTR job,WORD opt=PW_BESTFIT,
      WORD xscale=0,WORD yscale=0) {
      return ::PrintDIB(dibhandle,opt,xscale,yscale,job);
      };

// Save DIB to file
    WORD Save(LPCSTR fn) {
      return ::SaveDIB(dibhandle,fn);
      };

// Find height
    DWORD Height(void) {
      LPSTR dp=Lock();
      return ::DIBHeight(dp);
      };

// Find width
    DWORD Width(void) {
      LPSTR dp=Lock();
      return ::DIBWidth(dp);
      };

// Find # of colors
    WORD NumColors(void) {
      LPSTR dp=Lock();
      return ::DIBNumColors(dp);
      };

// Find bits
    LPSTR Bits(void) {
      LPSTR dp=Lock();
      return FindDIBBits(dp);
      };

// Get size
    void GetSize(CSize &sz) {
      sz=CSize((int)Width(),(int)Height());
      };

// Get underlying HDIB
    HDIB GetHDIB(void) {
      return dibhandle;
      };

// Make copy of HDIB (good for clipboard, etc)
    HDIB GetHDIBCopy(void) {
        BYTE huge *lpCopy, huge *lp;
        HANDLE     hCopy;
        DWORD      dwLen;
        if (!dibhandle) return NULL;
        dwLen = ::GlobalSize((HGLOBAL) dibhandle);
        if ((hCopy = (HANDLE) ::GlobalAlloc (GHND, dwLen)) != NULL)
          {
          lpCopy = (BYTE huge *) ::GlobalLock((HGLOBAL) hCopy);
          lp     = (BYTE huge *) Lock();
          while (dwLen--)
                        *lpCopy++ = *lp++;
          ::GlobalUnlock((HGLOBAL) hCopy);
          }
        return hCopy;
        };
    };




#endif


