/***************************************************************
	HLP_CTRL.H	Header file for HLP_CTRL.DLL

	Copyright (c) Andy Brundell 1994
****************************************************************/
#include <windows.h>

/* --- Application constants --- */

/* WinHelp embedded windows notification messages */
#define	EWM_RENDER			(0x706A)
#define	EWM_QUERYSIZE		(0x706B)
#define	EWM_ASKPALETTE		(0x706C)

/* Our general button ID */
#define IDB_BUTTON			(100)

/* WinHelp LDLLHandler notification messages */
#define DW_WHATMSGS			(1)
#define DW_TERM				(5)
#define DW_CALLBACKS		(10)

/* WinHelp API callback function pointer offset */
#define HE_API				(16)

/* LDLLHandler return requests */
#define DC_INITTERM			(0x02)
#define DC_CALLBACKS		(0x10)

/* --- Application structures --- */

/* This is our pointer to an internal WinHelp */
typedef LONG (CALLBACK *LPFN_WINHELP)(LPSTR, WORD, DWORD);

/* The CreateInfo structure is passed to us on window creation */
typedef struct	CREATEINFO {
	short			idMajVersion;
	short			idMinVersion;
	LPSTR			lpstrFileName;
	LPSTR			lpstrAuthorData;
	HANDLE			hfs;
	DWORD			coForeground;
	DWORD			coBackground;
	} CREATEINFO, FAR *QCI ;

/* The RenderInfo structure is passed when printing is required */
typedef struct {
	RECT			rc;
	HDC				hDC;
	} RENDERINFO, FAR *QRI;

/* The HelpTask structure is used to track the different tasks */
typedef struct HELPTASK {
	HTASK			ThisTask;		// Key field
	LPFN_WINHELP	lpfnWinHelp;	// Pointer to internal API
	struct HELPTASK FAR *NextTask;	// Chain field
	} HELPTASK, FAR *LPHELPTASK;	

/* HelpButton structure is used to track the different buttons */
typedef struct HELPBUTTON {
	HWND			ThisButton;   /* Key field */
	char 			ThisText[30]; /* Button Text */
	char 			ThisFile[127];/* Owning Help File*/
	char			ThisCmd[255]; /* Macro Command */
	DWORD			ThisColor;    /* Bckgrnd Color */
	POINT			ThisSize;     /* Button Size */
	struct HELPBUTTON FAR *NextButton;    /* Chain field */
	} HELPBUTTON, FAR *LPHELPBUTTON;

/* --- Exported functions --- */

/* EWndProc is the window proc function for the embedded window */
LONG CALLBACK EWndProc (HWND, WORD, WPARAM, LPARAM);
/* LDLLHandler is the WinHelp notification interface */
LONG CALLBACK LDLLHandler	(WORD, LONG, LONG);
/* InitiateControls is a dummy initialization function that causes
   winhelp to call LDLLHandler. */
BOOL CALLBACK InitiateControls(LPSTR);

/* --- Non-Exported functions --- */

/* GetTaskInfo loads the internal WinHelp function pointer */
BOOL		 PASCAL GetTaskInfo(FARPROC FAR *);
/* GetThisTask returns the task that requested button execution */
LPHELPTASK	 PASCAL GetThisTask(void);
/* GetButtonInfo loads a button into our button list */
BOOL		 PASCAL GetButtonInfo(HWND, QCI);
/* GetThisButton returns the current buttons info */
LPHELPBUTTON PASCAL GetThisButton(HWND);

/* RenderBitmapButton creates a bitmap button for printing */
LONG		 PASCAL RenderBitmapButton(LPHELPBUTTON, QRI);
/* ExecuteButtonCommand executes the button command */
BOOL		 PASCAL ExecuteButtonCommand(HWND);
