#ifndef __LOGSPAL_H__
#define __LOGSPAL_H__

//---------------------------------------------------------------------------
//
//	File:			LOGSPAL.H
//	Programmer: 	Bob Provencher
//	Create Date:	1/15/95
//	Last Mod Date:	3/5/95
//	Description:	LogSystemPalette class definition
//
//	Copyright (c) 1994, 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#ifndef __LOGPAL_H__
#include "logpal.h"
#endif

class LogSystemPalette : public LogPalette
{

private:

	static COLORREF	statColors[ COLOR_BTNHIGHLIGHT + 1 ];
    static COLORREF	bwColorMap[ COLOR_BTNHIGHLIGHT + 1 ];

public:

	static BOOL IsPaletteDevice( HDC h = 0 )
	{
		BOOL is;
		HDC hDC;
		hDC = h ? h : GetDC( 0 );
		is = GetDeviceCaps( hDC, RASTERCAPS ) & RC_PALETTE;
		if ( !h )
			ReleaseDC( 0, hDC );
		return is;
	}

	static UINT GetPaletteSize( HDC h = 0 )
	{
		UINT size = 0;
		if ( IsPaletteDevice() )
		{
			HDC hDC;
			hDC = h ? h : GetDC( 0 );
			size = GetDeviceCaps( hDC, SIZEPALETTE );
			if ( !h )
				ReleaseDC( 0, hDC );
		}
		return size;
	}

	static void SaveColors();

	static UINT GetUse( HDC h = 0 )
	{
		UINT use = 0;
		HDC hDC;
		hDC = h ? h : GetDC( 0 );
		if ( IsPaletteDevice( hDC ) )
			use = GetSystemPaletteUse( hDC );
		if ( !h )
			ReleaseDC( 0, hDC );
		return use;
	}

	static void RestoreColors();

	static UINT SetUse( UINT new_use, HDC h = 0 )
	{
		UINT old_use = 0;
		HDC hDC;
		hDC = h ? h : GetDC( 0 );
		if ( IsPaletteDevice( hDC ) )
		{
			if ( new_use == SYSPAL_NOSTATIC )
				SaveColors();
			else
				RestoreColors();
			old_use = SetSystemPaletteUse( hDC, new_use );
		}
		if ( !h )
			ReleaseDC( 0, hDC );
		return old_use;
	}

	LogSystemPalette()
	{
    	Update();
	}

	BOOL Update()
	{
		BOOL fReturn = FALSE;
		UINT size = GetPaletteSize();
		if ( size && ResizeTo( size ) )
		{
			GetSystemEntries( 0, size );
			fReturn = TRUE;
		}
        return fReturn;
	}

};

#endif

