// partyvw.cpp : implementation of the CPartyView class
//

#include "stdafx.h"
#include "party.h"

#include "partydoc.h"
#include "partyvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPartyView

IMPLEMENT_DYNCREATE(CPartyView, CFormView)

BEGIN_MESSAGE_MAP(CPartyView, CFormView)
    //{{AFX_MSG_MAP(CPartyView)
    ON_BN_CLICKED(IDC_BTN_SEND, OnBtnSend)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPartyView construction/destruction

CPartyView::CPartyView()
    : CFormView(CPartyView::IDD)
{
    //{{AFX_DATA_INIT(CPartyView)
    m_Message = "";
    m_TalkTo = "192.34.150.38";
    m_ReceivePort = 5001;
    //}}AFX_DATA_INIT
    // TODO: add construction code here
    
    // TC:
    // Note that sockets haven't been allocated yet.
     SetReceiveSocketAllocated(FALSE);
     SetSendSocketAllocated(FALSE);

}

CPartyView::~CPartyView()
{
}

void CPartyView::DoDataExchange(CDataExchange* pDX)
{
    CFormView::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CPartyView)
    DDX_Text(pDX, IDC_MESSAGE, m_Message);
    DDV_MaxChars(pDX, m_Message, 100);
    DDX_Text(pDX, IDC_TALK_TO, m_TalkTo);
    DDX_Text(pDX, IDC_EDIT_RECEIVE_PORT, m_ReceivePort);
    DDV_MinMaxUInt(pDX, m_ReceivePort, 0, 65535);
    //}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CPartyView diagnostics

#ifdef _DEBUG
void CPartyView::AssertValid() const
{
    CFormView::AssertValid();
}

void CPartyView::Dump(CDumpContext& dc) const
{
    CFormView::Dump(dc);
}

CPartyDoc* CPartyView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPartyDoc)));
    return (CPartyDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPartyView implementation

// TC: This whole routine
void CPartyView::OnInitialUpdate()
{
    // These two lines ensure that the CFormView's parent
    // fits the main dialog properly.
    GetParentFrame()->RecalcLayout();
    ResizeParentToFit();

    // Initialize dialog from member variables.
    UpdateData(FALSE);

    // Attempt to allocate client & server sockets.
    AllocateSockets();
}

/////////////////////////////////////////////////////////////////////////////
// CPartyView operations

CPartyView::AllocateSockets()
{
    // Return value from this routine depends on whether sockets
    // can be allocated properly.
    BOOL bRet = FALSE;
    
    // Socket descriptors are in the document.
    CPartyDoc *pDoc = GetDocument();
    
    // Retrieve data from controls.
    UpdateData(TRUE);

    // Allocate and bind the server (receiving) socket.    
    if (pDoc->Receive.Create(m_ReceivePort, SOCK_DGRAM, 
        FD_READ|FD_WRITE|FD_OOB|FD_ACCEPT|FD_CONNECT|FD_CLOSE)
         == FALSE)
    {
        AddText(WinsockErrorMsg(pDoc->Receive.GetLastError(),
            "Unable to create receive socket. "));
    }
    else
    {
        SetReceiveSocketAllocated(TRUE);
    }
    
    // Allocate and bind the client (sending) socket.    
    if (pDoc->Talk.Create(0, SOCK_DGRAM, 
        FD_READ|FD_WRITE|FD_OOB|FD_ACCEPT|FD_CONNECT|FD_CLOSE,
        m_TalkTo) == FALSE)
    {
        AddText(WinsockErrorMsg(pDoc->Talk.GetLastError(), "Unable to create send socket. "));
    }
    else
    {
        bRet = TRUE;
        SetSendSocketAllocated(TRUE);
    }
    return bRet;    
}



// Add a message to the History dialog box.
// This keeps a "stack" of recent messages visible to
// the user.
void CPartyView::AddText(const char* Text)
{
    CListBox* pHistory = (CListBox*) GetDlgItem(IDC_HISTORY_LIST);
    if (pHistory != NULL)
        pHistory->InsertString(0, Text);
}


/////////////////////////////////////////////////////////////////////////////
// Pass it a Winsock error code, and it returns the error message associated
// with that code. If it's not here, just print "Error code #" and the number.
// Only covers the more common errors.
// If you include some text, it's placed before the error message
// this routine generates.
CString& WinsockErrorMsg(int ErrorCode, const char* StartWith)
{
    static CString Msg;
    static char ErrorMsg[100];
    switch (ErrorCode)
    {    
        default:
            wsprintf(ErrorMsg, "Error code #%d", ErrorCode);
            Msg = ErrorMsg;
            break;
            
        case 0:
            Msg = "No error.";
            break;            

        case WSAEADDRINUSE:
            Msg = "The specified address is already in use.";
            break;
    
        case WSAEADDRNOTAVAIL:
            Msg = "The specified address is not available from the local machine.";
            break;

        case WSAEAFNOSUPPORT:
            Msg = "Addresses in the specified family cannot be used with this socket.";
            break;
                                                                                                       
        case WSAECONNABORTED:
            Msg = "The virtual circuit was aborted due to timeout or other failure.";
            break;

        case WSAECONNRESET:
            Msg = "The virtual circuit was reset by the remote side.";
            break;

        case WSAEDESTADDRREQ:
            Msg = "A destination address is required.";
            break;

        case WSAEFAULT:
            Msg = "The lpBuf or lpSockAddr parameters are not part of the user address space, or the lpSockAddr argument is too small (less than the size of a SOCKADDR structure).";
            break;
            
        case WSAEHOSTUNREACH:
            Msg = "Host unreachable.";
            break;            

        case WSAEINPROGRESS:
            Msg = "A blocking Windows Sockets operation is in progress.";
            break;
            
        case WSAEINVAL:
            Msg = "Invalid argument";
            break;            

        case WSAEMSGSIZE:
            Msg = "The socket is of type SOCK_DGRAM, and the datagram is larger than the maximum supported by the Windows Sockets implementation.";
            break;

        case WSAENETDOWN:
            Msg = "The Windows Sockets implementation detected that the network subsystem failed.";
            break;
            
        case WSAENETRESET:
            Msg = "The connection must be reset because the Windows Sockets implementation dropped it.";
            break;

        case WSAENETUNREACH:
            Msg = "The network cannot be reached from this host at this time.";
            break;

        case WSAENOBUFS:
            Msg = "The Windows Sockets implementation reports a buffer deadlock.";
            break;

        case WSAENOTCONN:
            Msg = "The socket is not connected (SOCK_STREAM only).";
            break;
                  
        case WSAENOTSOCK:
            Msg = "The descriptor is not a socket.";
            break;

        case WSAEOPNOTSUPP:
            Msg = "MSG_OOB was specified, but the socket is not of type SOCK_STREAM.";
            break;

        case WSAESHUTDOWN:
            Msg = "The socket has been shut down; it is not possible to call SendTo on a socket after ShutDown ";
            break;

        case WSAEWOULDBLOCK:
            Msg = "The socket is marked as nonblocking and the requested operation would block.";
            break;

        case WSANOTINITIALISED:
            Msg = "Winsock not initialized.  Call AfxSocketInit() before using this API call.";
            break;
    }
    
    if (StartWith)
    {
        Msg = StartWith + Msg;
    }
    return Msg;
}


// TC:
// Returns a pointer to the current view.
// Globally available.
// "Inspired" by some similar code from MSL.
CPartyView* CPartyView::GetView()
{
    CFrameWnd *pFrame = (CFrameWnd*)(AfxGetApp()->m_pMainWnd);
    CView* pView = pFrame->GetActiveView();
    return (CPartyView*) pView;
}


void CPartyView::OnBtnSend()
{
    // Information about an Internet address.
    // IN_ADDR Address;
    
    // HOSTENT contains information about a host (in this case,
    // the machine on the other end). 
    LPHOSTENT lpHostent;

    // Pointer to a dotted decimal address string.    
    char* pszIPAddress;
    
    // Allocate sockets the first time this is used.
    if (!SocketsAllocated())
    {
        // Exit if unable to.
        if (!AllocateSockets())
        {
            AddText("Sockets not allocated and initialized.");
            return;
        }            
    }

    // Obtain a pointer to the current document.    
    CPartyDoc *pDoc = GetDocument();
    
    // Retrieve data from controls.
    UpdateData(TRUE);
    
    // Convert the symbolic name, say, "ada@velocity.com", to
    // a dotted decimal string, say, 123.456.789.69.
    lpHostent = gethostbyname(m_TalkTo);
    if (lpHostent)
    {
        pszIPAddress = inet_ntoa(*(LPIN_ADDR)*(lpHostent->h_addr_list));
    }
    
    // Write out the message to the address specified in the
    // "Talk to" edit box.
    // 
    //int Sent = pDoc->Talk.SendTo((const char*) m_Message, 
    //    m_Message.GetLength(), m_ReceivePort, m_TalkTo);
    int Sent = pDoc->Talk.SendTo((const char*) m_Message, 
        m_Message.GetLength(), m_ReceivePort, pszIPAddress);
    if (Sent == SOCKET_ERROR)
    {
        // Display error message if unable to.
        AddText(WinsockErrorMsg(pDoc->Talk.GetLastError(), "Unable to send message. "));
    }
    else
    {
        // Show how many bytes were sent if successful.
        //char Msg[150];
        //wsprintf(Msg, "Sent %d bytes", Sent);
        AddText(m_Message);
    }
    
}
