// partydoc.h : interface of the CPartyDoc class
//
/////////////////////////////////////////////////////////////////////////////

// TC:
// Interface to the MFC Winsock classes.
#include <afxsock.h>

// TC:
// Interface to the server (receiving) socket class.
#include "csox.h"

class CPartyDoc : public CDocument
{
protected: // create from serialization only
    CPartyDoc();
    DECLARE_DYNCREATE(CPartyDoc)

// Attributes
public:
    // TC:
    // Server (receiving) socket implemented in CSOX.CPP.
    CReceiveSocket Receive;

    // TC:
    // Client (sending) socket using standard MFC class.
    CAsyncSocket Talk;

// Operations
public:
    // TC:
    void OnReceive(const char* pBuf, const int iBufLen, const char* pszFromAddress);

// Implementation
public:
    virtual ~CPartyDoc();
    virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump(CDumpContext& dc) const;
#endif

protected:
    virtual BOOL OnNewDocument();

// Generated message map functions
protected:
    //{{AFX_MSG(CPartyDoc)
        // NOTE - the ClassWizard will add and remove member functions here.
        //    DO NOT EDIT what you see in these blocks of generated code !
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
