

// Implementation for the CReceiveSocket (server) class.
#include "stdafx.h"

#include "partydoc.h"
#include "csox.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CReceiveSocket::CReceiveSocket()
{
    CAsyncSocket::CAsyncSocket();
}

void CReceiveSocket::OnReceive(int nErrorCode)
{                                  
    // HOSTENT contains information about a host (in this case,
    // the machine on the other end). 
    LPHOSTENT lpHostent;

    // Binary version of dotted decimal address string.
    DWORD dwIPAddress;
    

    // Buffer large enough to hold a user-typed message, plus
    // 1 for terminating 0.
    char buf[MAX_MESSAGE_LENGTH + 1];
    CAsyncSocket::OnReceive(nErrorCode); 
    
    // Return value param for ReceiveFrom() tells you who sent
    // the message.
    CString SentFromAddr;
    
    // Return value param for ReceiveFrom() tells you the port
    // from which the message was sent.
    UINT SentFromPort;

    // This is the standard place to do a Receive(), although
    // it doesn't have to be done here.
    int Received = ReceiveFrom(buf, 100, SentFromAddr, 
        SentFromPort);
               
    // Convert dotted decimal string to binary.               
    dwIPAddress = ::inet_addr((const char*) SentFromAddr);
    
    // Convert the binary address to a symbolic value,
    // such as "ada@velocity.com",    
    lpHostent = ::gethostbyaddr((LPSTR)&dwIPAddress, 4, AF_INET);

    // If it worked, make it the address used in the message.    
    if (lpHostent)
    {
        SentFromAddr = lpHostent->h_name;
    }
        
    // Make the message a C-style string.        
    buf[Received] = 0;
    
    // Call on the document to spit the message into the listbox.
    ((CPartyDoc*)m_pDoc)->OnReceive(buf, Received, 
        SentFromAddr); 

} // CReceiveSocket::OnReceive(int nErrorCode)
