/*

	DLList (doubly linked list) object class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94


*/


#define CLASS DLList

#include "pcoope2.h"

object CLASS;

extern object DLLink;


instVars {
	unsigned numLinks;
	object curView;
	 };

INSTANCEPOLY(pAcc);
INSTANCEPOLY(pAdd);
INSTANCEPOLY(pRmv);
INSTANCEPOLY(pNext);
INSTANCEPOLY(pPrev);
INSTANCEPOLY(pLook);
INSTANCEPOLY(pUnLnk);
INSTANCEPOLY(pIns);

INCLUDEPOLY(pAcc);
INCLUDEPOLY(pSet);

cFunc object New(object instance);
cFunc object Kill(object instance);

iFunc object Acc(object instance);
iFunc object Add(object instance, object newLink);
iFunc object Rmv(object instance);
iFunc object Next(object instance);
iFunc object Prev(object instance);
iFunc object Look(object instance);
iFunc object UnLnk(object instance, object unLink);
iFunc object Ins(object instance, object link);


ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,DLLink,NULL);

MAKE_C_POLY(New);

MAKE_D_POLY(Kill);

MAKE_I_POLY(Acc);
MAKE_I_POLY(Add);
MAKE_I_POLY(Rmv);
MAKE_I_POLY(Next);
MAKE_I_POLY(Prev);
MAKE_I_POLY(Look);
MAKE_I_POLY(UnLnk);
MAKE_I_POLY(Ins);

EndClassInstall;
}

#define pAcc I_POLY(pAcc)
#define pSet I_POLY(pSet)


cFunc object New(object instance)
{
BEGIN_NEW;

makeInst(CLASS,&instance);

pNew(DLLink,NULL,NULL);

END_NEW;
}


iFunc object Acc(object instance)
{
return (object) ((cast) IVPTR->numLinks);
}


iFunc object Add(object instance, object record)
{
object flink;
object blink;
object current;
object tail;
object head;
GETIVPTR;

if(NULL==(current=getAinst(DLLink,record))) return NULL;
head=getAinst(DLLink,instance);
pAcc(head,&flink,&tail);
pSet(current,head,tail);
pSet(head,flink,current);
pAcc(tail,&flink,&blink);
pSet(tail,current,blink);
ivPtr->numLinks++;
return Base;
}


iFunc object Rmv(object instance)
{
object flink;
object blink;
object head;
object current;
object next;
GETIVPTR;

if(ivPtr->numLinks<=0) return NULL;
head=getAinst(DLLink,instance);
pAcc(head,&current,&blink);
pAcc(current,&next,&flink);
pAcc(next,&flink,&current);
pSet(current,current,current);
pSet(next,flink,head);
pSet(head,next,blink);
ivPtr->numLinks--;
while(((instType *)current)->child !=NULL)
    {
    current=((instType *) current)->child;
    }
return current;
}


iFunc object Look(object instance)
{
object flink;
object blink;
object current;
GETIVPTR;

if(ivPtr->numLinks<=0) return NULL;

current=getAinst(DLLink,instance);
pAcc(current,&flink,&blink);
current=ivPtr->curView=flink;
while(((instType *)current)->child !=NULL)
    {
    current=((instType *) current)->child;
    }
return current;
}


iFunc object Next(object instance)
{
object blink;
object current;
GETIVPTR;

if(ivPtr->numLinks<=0 || ivPtr->curView==NULL) return NULL;
current=ivPtr->curView;
pAcc(current,&current,&blink);
if(current==getAinst(DLLink,instance)) return NULL;
ivPtr->curView=current;
while(((instType *)current)->child !=NULL)
    {
    current=((instType *) current)->child;
    }
return current;
}


iFunc object Prev(object instance)
{
object flink;
object current;
GETIVPTR;

if(ivPtr->numLinks<=0 || ivPtr->curView==NULL) return NULL;
current=ivPtr->curView;
pAcc(current,&flink,&current);
if(current==getAinst(DLLink,instance)) return NULL;
ivPtr->curView=current;
while(((instType *)current)->child !=NULL)
    {
    current=((instType *) current)->child;
    }
return current;
}


iFunc object UnLnk(object instance, object record)
{
object flink;
object blink;
object current;
object next;
object prev;
GETIVPTR;

if(ivPtr->numLinks<=0 || NULL==(current=getAinst(DLLink,record)))
    return NULL;
pAcc(current,&next,&prev);
pAcc(next,&flink,&blink);
pSet(next,flink,prev);
pAcc(next,&flink,&blink);
pSet(prev,next,blink);
pSet(current,current,current);
return Base;
}


iFunc object Ins(object instance, object record)
{
object flink;
object blink;
object current;
object next;
object head;
GETIVPTR;

if(NULL==(current=getAinst(DLLink,record))) return NULL;
head=getAinst(DLLink,instance);
pAcc(head,&flink,&blink);
next=flink;
pSet(current,next,head);
pSet(head,current,blink);
pAcc(next,&flink,&blink);
pSet(next,flink,current);
ivPtr->numLinks++;
return Base;
}


cFunc object Kill(object instance)
{
return pKill(Base,instance);
}


