{$IFDEF VER70}
{$K+}
{$ENDIF}
UNIT TidyWinA;
(**) INTERFACE (**)
USES WinTypes, WinProcs, Strings, Win31, {$IFNDEF VER70} WObjects;
{$ELSE} ODialogs, OWindows, Objects;{$ENDIF}
CONST
  MaxGroups = 40; {Win 3.1 supports a maximum of 40 ProgMan groups}
TYPE
  PHwndArray = ^THWndArray;
  THWndArray = ARRAY[0..MaxGroups] OF HWnd;

  PTidyWindowA = ^TTidyWindowA;
  TTidyWindowA = OBJECT(TDlgWindow)
    PMWindow : hWnd;
    THA      : THWndArray;
    Quiet    : Boolean;
    oldCur   : hCursor;
    CONSTRUCTOR Init(AParent : PWindowsObject; AName : PChar);
    PROCEDURE GetGroupHandles;
    PROCEDURE ArrangeAll;
    (**) PRIVATE (**)
    ArrangeCmd : Word;
    PROCEDURE GetAACmd;
  END;

  FUNCTION GetGroup(H : hWnd; PHA : PHWndArray) : Boolean; Export;

(**) IMPLEMENTATION (**)
  FUNCTION GetGroup(H : hWnd; PHA : PHWndArray) : Boolean;
    {callback function used in saving layout of groups}
  VAR CBuf : ARRAY[0..12] OF Char;
  BEGIN
    GetGroup := TRUE; {continue enumerating}
    GetClassName(H, CBuf, 12);
      {if this is a group window, collect its handle}
    IF (StrComp(CBuf, 'PMGroup') = 0) AND (PHA^[0] < 40) THEN
      BEGIN
        Inc(PHA^[0]);
        PHA^[PHA^[0]] := H;
      END;
  END;

  CONSTRUCTOR TTidyWindowA.Init(AParent : PWindowsObject;
    AName : PChar);
  BEGIN
    TDlgWindow.Init(AParent, AName);
    Quiet    := FALSE;
    PMWindow := FindWindow('Progman', NIL);
    GetAACmd;
    IF ArrangeCmd = 0 THEN PMWindow := 0;
  END;

  PROCEDURE TTidyWindowA.GetGroupHandles;
  VAR theInst  : TFarProc;
  BEGIN
      {Fill the array with the handles of all the group windows}
    FillChar(THA, SizeOf(THA), 0);
{$IFDEF VER70} {use BP smart callbacks if available}
    EnumChildWindows(pmWindow, @GetGroup, LongInt(@THA));
{$ELSE}
    TheInst := MakeProcInstance(@GetGroup, hInstance);
    EnumChildWindows(pmWindow, theInst, LongInt(@THA));
    FreeProcInstance(theInst);
{$ENDIF}
  END;

  PROCEDURE TTidyWindowA.ArrangeAll;
  VAR N   : Word;

    PROCEDURE ArrangeOne(H : HWnd);
    BEGIN
      ShowWindow(H, sw_Restore);
      SendMessage(PMWindow, wm_Command, ArrangeCmd, 0);
      ShowWindow(H, sw_ShowMinimized);
    END;

  BEGIN
    IF pmWindow = 0 THEN Exit;
    OldCur := SetCursor(LoadCursor(0, idc_Wait));
    SetCapture(hWindow);
    GetGroupHandles;
      {arrange icons in each group window}
    ShowWindow(pmWindow, sw_Hide);
    FOR N := 1 TO THA[0] DO ArrangeOne(THA[N]);
    ShowWindow(pmWindow, sw_Show);
      {arrange icons of group windows themselves}
    SendMessage(PMWindow, wm_Command, ArrangeCmd, 0);
    IF NOT Quiet THEN MessageBeep(mb_IconInformation);
    MessageBox(hWindow, 'All icons arranged', 'WINTIDY',
      mb_OK + mb_IconInformation);
    SetCursor(OldCur);
    ReleaseCapture;
  END;

  PROCEDURE TTidyWindowA.GetAACmd;
  CONST bSize = 20;
  VAR
    MainM, SubM : hMenu;
    count, N    : Word;
    mBuff       : ARRAY[0..bSize] OF Char;
  BEGIN
    ArrangeCmd := 0;
    IF PMWindow = 0 THEN Exit;
    MainM := GetMenu(PMWindow);
    Count := GetMenuItemCount(MainM);
    SubM := 0;
    FOR N := 0 to pred(Count) DO
      BEGIN
        GetMenuString(MainM, N, mBuff, bSize, mf_ByPosition);
        IF StrLIComp(mBuff, '&Window', 7) = 0 THEN
          SubM := GetSubMenu(MainM, N)
      END;
    IF SubM = 0 THEN Exit;
    Count := GetMenuItemCount(SubM);
    FOR N := 0 TO pred(Count) DO
      BEGIN
        GetMenuString(SubM, N, mBuff, bSize, mf_ByPosition);
        IF StrLIComp(mBuff, '&Arrange Icons',14) = 0 THEN
          ArrangeCmd := GetMenuItemID(SubM, N);
      END;
  END;
END.
