PROGRAM GroupVu;
USES WinCrt, WinTypes, WinProcs, WinDos, Strings, GroupType,
  GroupFile;
CONST GroupX : PChar = 'GROUPxx';
VAR
  GroupNum : Word;
  buff     : ARRAY[0..80] OF Char;
  T        : TGroupFile;
  Item     : Word;
  TID      : TItemData;
BEGIN
    {set up *BIG* CrtWindow}
  WindowOrg.X := 0;
  WindowOrg.Y := 0;
  WindowSize.X := GetSystemMetrics(sm_CXScreen);
  WindowSize.Y := GetSystemMetrics(sm_CYScreen);
  ScreenSize.X := (WindowSize.X -
    GetSystemMetrics(sm_CXVScroll) -
    GetSystemMetrics(sm_CXFrame)) DIV 8;
  ScreenSize.Y := 65520 DIV ScreenSize.X;
  AutoTracking := FALSE;
  InitWinCrt;
  WriteLn('REPORT of all GRP files used by currently ',
    'active ProgMan groups');
  WriteLn('==========================================',
    '=====================');
  FOR GroupNum := 1 TO 40 DO
    BEGIN
      wvsprintf(Groupx, 'Group%u', GroupNum);
      GetPrivateProfileString('Groups', Groupx, '', buff, 80,
        'PROGMAN.INI');
      IF buff[0] <> #0 THEN
        BEGIN
          Write(GroupX, ' - ',buff);
          T.Init(Buff);
          IF T.GetStatus <> msg_Ok THEN
            BEGIN
              WriteLn(' - ',T.GetStatStr(buff, 80));
              WriteLn;
            END
          ELSE
            BEGIN
              WriteLn(' "', T.fpName(buff, 80),'"');
              Write('    Display status : ');
              CASE T.fnCmdShow OF
                0         : WriteLn('Hide       ');
                1,4,5,8,9 : WriteLn('Normal     ');
                2,6,7     : WriteLn('Minimized  ');
                3         : WriteLn('Maximized  ');
              END;
              WITH T.frcNormal^ DO
                WriteLn('    normal coords  : (', left, ',', top,
                  ',', right, ',', bottom, ')');
              WITH T.fptMin^ DO
                WriteLn('    minimized pos''n: (',X,',',Y,')');
              FOR Item := 0 TO pred(T.fcItems) DO
                IF T.GetNthItem(Item, TID) THEN
                  BEGIN
                    WITH TID.Pt DO Write('(',X:3,',',Y:3,')');
                    IF T.GetItemTagMin(Item) THEN Write(' <m>');
                    Write(' "', T.PCharFmOffset(TID.pName, buff,
                      80));
                    Write('" - ', T.PCharFmOffset(TID.pCommand,
                      buff, 80));
                    IF T.GetItemTagHotStr(Item, buff, 80) THEN
                      WriteLn(' <<',buff,'>>')
                    ELSE WriteLn;
                  END;
              WriteLn;
            END;
          T.Done;
        END;
    END;
END.