UNIT GroupType;
(**) INTERFACE (**)
USES WinTypes;
(*NOTE: In the data structures that follow, I've marked important
  fields with the symbol {!}. *)
TYPE
  rgiItemType = ARRAY[0..49] OF Word; {max 50 items per group}

  PGroupHeader = ^TGroupHeader;
  TGroupHeader = RECORD
{!} cIdentifier   : ARRAY[0..3] OF Char; {must be 'PMCC'}
{!} wCheckSum     : Word;    {adjusted to make the sum of all the
                              words in the group file be 0}
{!} cbGroup       : Word;    {size of the group file, in bytes, NOT
                              including the tag data.}
{!} nCmdShow      : Word;    {flag that tells how ProgMan displays
                              the group; see SW_xxxx constants for
                              the ShowWindow API function}
{!} rcNormal      : TRect;   {the coordinates used by the group
                              window when neither min nor max}
{!} ptMin         : TPoint;  {the coordinates for the lower-left
                              corner of the group window in ProgMan}
{!} pName         : Word;    {offset from the beginning of the file
                              to the group's name string}
    wLogPixelsX   : Word;    {horizontal resolution of device for
                              which the group icons were created}
    wLogPixelsY   : Word;    {vertical resolution of device for
                              which the group icons were created}
      {NOTE: Next two items erroneously listed as WORD in SDK}
    wBitsPerPixel : Byte;    {bits per pixel of icon bitmaps}
    wPlanes       : Byte;    {count of bitplanes in icon bitmaps}
      {NOTE: Next item omitted from structure in SDK}
    wReserved     : Word;    {reserved - should be 0}
{!} cItems        : Word;    {number of TItemData structures in the
                              rgiItems array}
{!} rgiItems      : rgiItemType;  {an array of offsets to TItemData
                              structures in the group file.  NOTE:
                              SDK says this is an array of ItemData
                              structures - it is incorrect}
  END;

  (* Equivalent structure in C
     struct tagGROUPHEADER {
         char  cIdentifier[4|;
         WORD  wCheckSum;
         WORD  cbGroup;
         WORD  nCmdShow;
         RECT  rcNormal;
         POINT ptMin;
         WORD  pName;
         WORD  wLogPixelsX;
         WORD  wLogPixelsY;
         BYTE  bBitsPerPixel;
         BYTE  bPlanes;
         WORD  wReserved;  // Should be 0x0000
         WORD  cItems;
         WORD  rgiItems[cItems|;
     }*)

  PItemData = ^TItemData;
  TItemData = RECORD
{!} pt         : TPoint; {the coordinates for the lower-left
                          corner of an icon in the group window.}
    iIcon      : Word;   {the index value for the icon, i.e the
                          the position of the icon in its file
                          (see pIconPath)}
    cbHeader   : Word;   {the count of bytes in the icon resource
                          cbResource}
    cbANDPlane : Word;   {the count of bytes in the icon's AND mask}
    cbXORPlane : Word;   {the count of bytes in the icon's XOR mask}
    pHeader    : Word;   {offset from the beginning of the group
                          file to the icon's resource header (see
                          TIconResourceHeader)}
    pANDPlane  : Word;   {offset from the beginning of the group
                          file to the icon's AND mask}
    pXORPlane  : Word;   {offset from the beginning of the group
                          file to the icon's XOR mask}
{!} pName      : Word;   {offset from the beginning of the group
                          file to the item name string}
{!} pCommand   : Word;   {offset from the beginning of the group
                          file to the command line string}
    pIconPath  : Word;   {offset from the beginning of the group
                          file to the name of the file containing
                          the icon for this item}
  END;

  (* Equivalent structure in C:
     struct tagITEMDATA {
         POINT pt;
         WORD  iIcon;
         WORD  cbHeader;
         WORD  cbANDPlane;
         WORD  cbXORPlane;
         WORD  pHeader;
         WORD  pANDPlane;
         WORD  pXORPlane;
         WORD  pName;
         WORD  pCommand;
         WORD  pIconPath;
     }*)

  PIconResourceHeader = ^TIconResourceHeader;
  TIconResourceHeader = RECORD
    xHotSpot   : Integer; {Should be 0}
    yHotSpot   : Integer; {Should be 0}
    cx         : Integer; {Icon width}
    cy         : Integer; {Icon height}
    cbWidth    : Integer; {Bytes per row accounting for WORD alignment}
    bPlanes    : Byte;    {Count of planes}
    bBitsPixel : Byte;    {Bits per pixel}
  END;

  (* Equivalent structure in C:
     struct tagICONRESOURCEHEADER{
         int xHotSpot;    // Should be 0
         int yHotSpot;    // Should be 0
         int cx;          // Icon width
         int cy;          // Icon height
         int cbWidth;     // Bytes per row accounting
                          // for WORD alignment
         BYTE bPlanes;    // Count of planes
         BYTE bBitsPixel; // Bits per pixel
       }*)

  PTagData = ^TTagData;
  TTagData = RECORD
    wID   : Word; {identifies type of tag data.  Possible values:
       Value  Meaning
       8000h  the first TTagData structure
       8101h  rgbString is the item's path as an ASCIIZ string.
              NOTE: Changing "Working Directory" in the Properties
              dialog changes the *command* for the item; the
              TTagData shows the actual location of the app.
       8102h  rgbShortcut identifies the hotkey for the item.
              Its high byte is a combination of any two of:
                2 = Ctrl
                1 = Shift
                4 = Alt
              Its low byte is the ASCII code of the key.
       8103h  If present, means the item will run minimized.
              The structure is just 6 bytes in size.
       FFFFh  the last TagData structure; don't rely on cb
              to reflect size, as it is usually 0
    }
    wItem : Word; {number of item corresponding to this tag}
    cb    : Word; {size in bytes of the TTagData structure}
    CASE Word OF
      $8101 : (rgbString : ARRAY[0..144] OF Char);
      $8102 : (rgbShortcut : Word); 
      $8103 : (rgbNada : RECORD END);
    END;
    
  (* Equivalent structure in C
     struct tagTAGDATA{
         WORD wID;
         WORD wItem:
         WORD cb;
         BYTE rgb[1];
     }*)
(**) IMPLEMENTATION (**)
END.