// CpuType - System Registry Demonstration for Windows NT
// Retrieves and Displays CPU Type of Host Machine
// Tested with Oct 92 (beta) Release of Windows NT
// Copyright (C) 1992 Ray Duncan
// PC Magazine * Ziff Davis Publishing

#include <stdlib.h>
#include <stdio.h>
#include <windows.h>

// 
// GetSZKeyData() -- given a currently open registry key, the name 
// of a subkey, and a value name, returns a pointer to the ASCIIZ data 
// associated with that value name.  If any necessary function fails 
// or the data is not ASCIIZ, returns NULL.
//
LPSTR GetSZKeyData(HKEY hKey, LPSTR szSubKeyName, LPSTR szValueName)
{
    HKEY hNewKey;
    char chClass[10];
    DWORD dwType;
    DWORD cSubKeys;    
    DWORD cbMaxSubkey; 
    DWORD cbMaxClass;  
    DWORD cValues; 
    DWORD cbMaxValueName;
    DWORD cbMaxValueData;  
    DWORD cbSecurityDescriptor;    
    DWORD cbClassSize = 10 ; // sizeof(chClass);
    LPSTR pKeyValue;
    FILETIME ftLastWriteTime;

    // open the specified subkey
    if(ERROR_SUCCESS != 
       RegOpenKeyEx(hKey, szSubKeyName, 0, KEY_QUERY_VALUE, &hNewKey))
        return(NULL);

    // retrieve size of largest data field for this subkey
    if(ERROR_SUCCESS != 
       RegQueryInfoKey(hNewKey, chClass, &cbClassSize, NULL,
            &cSubKeys, &cbMaxSubkey, &cbMaxClass, &cValues, &cbMaxValueName, 
            &cbMaxValueData, &cbSecurityDescriptor, &ftLastWriteTime))
    {
        RegCloseKey(hNewKey);
        return(NULL);
    }

    cbMaxValueData++;

    // allocate memory to hold the incoming data
    pKeyValue = malloc(cbMaxValueData * sizeof(TCHAR));

    if(pKeyValue == NULL)
    {
        RegCloseKey(hNewKey);
        return(NULL);
    }

    // retrieve data for specified key, subkey, and valuename
    if(ERROR_SUCCESS != 
       RegQueryValueEx(hNewKey, szValueName, NULL, &dwType, 
            (LPBYTE) pKeyValue, &cbMaxValueData))
    {
        free(pKeyValue);
        RegCloseKey(hNewKey);
        return(NULL);
    }

    // if data is not ASCIIZ, return error
    if(dwType != REG_SZ)
    {
        free(pKeyValue);
        RegCloseKey(hNewKey);
        return(NULL);
    }

    // release the subkey
    RegCloseKey(hNewKey);

    // return pointer to the ASCIIZ key value
    return(pKeyValue);                      
}                                           

// this simple demonstration of use of the registry
// just retrieves and displays the CPU type.
VOID main(VOID)
{
    LPSTR pKeyValue;

    pKeyValue = GetSZKeyData(HKEY_LOCAL_MACHINE,
        "Hardware\\Description\\System\\CentralProcessor\\0",
        "Identifier");

    if(pKeyValue)
        printf("\nThe CPU type is: %s.\n", pKeyValue);
    else
        printf("\nCPU type not found in registry.\n");
}

