/*
**                    --- selftest.c ---
**
**  EXAMPLE CODE: Very simple terminal emulator.
**
**  This example program (not the PCL4W library) is donated to
**  the Public Domain by MarshallSoft Computing, Inc. It is
**  provided as an example of the use of the PCL4W.
**
*/

#define USECOMM

#include "windows.h"
#include "stdio.h"
#include "pcl4w.h"
#include "sioerror.h"
#include "ascii.h"
#include "selftest.h"
#include "message.h"
#include "line.h"
#include "paint.h"
#include "runtest.h"
#include "about.h"

/* public globals */

HWND hMainWnd;            /* main window handle */
int OnLineFlag = FALSE;   /* TRUE: online */
int FatalFlag = FALSE;    /* TRUE: fatal error */
char Temp[1024];          /* temporary 1K buffer */

/* private globals */

static HMENU hMenu;
static HANDLE hInstance;
static int ThePort = COM1;
static int WinWidth = 8 * NCOLS;
static int WinHeight = 12 * NROWS + 48;

/* miscellaneous functions */

void ErrorCheck(int);

int PASCAL WinMain(HANDLE hInst,HANDLE hPrevInstance,
                   LPSTR lpCmdLine,int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "SelftestIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "SelftestMenu";
    wc.lpszClassName = "SelftestWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }

 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "SelftestWClass", "Selftest",     WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,    CW_USEDEFAULT,
        WinWidth,         WinHeight,
        NULL,             NULL,
        hInstance,        NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);
 hMenu = GetMenu(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,NULL,NULL))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

long FAR PASCAL MainWndProc(HWND hWindow,UINT message,WPARAM wParam,LPARAM lParam)
{
 UINT idTimer;
 HDC hDC;
 PAINTSTRUCT ps;
 int i;
 int TheChar;
 int Count;
 static FARPROC lpProcAbout;


 hMainWnd = hWindow;
 switch (message)
   {
    case WM_COMMAND:
       switch(wParam)
           {case MSG_ABOUT:
              DialogBox(hInstance,"AboutBox",hMainWnd,lpProcAbout);
              break;

            case MSG_TEST:
              if(OnLineFlag) RunTest(ThePort);
              else DisplayLine("Must be online");
              break;

            case MSG_INSTRUCT:
              DisplayLine("\nConnect a loopback adapter to your port cable. Refer to LOOPBACK.DOC");
              DisplayLine("for instructions on how to make a loopback adapter. Very easy!");
              DisplayLine("For maximum performance, Windows port virtualization must be disabled.");
              DisplayLine("Refer to the users manual PCL4WUSR.DOC\n");
              break;

            case MSG_DEBUG:
              break;

            case MSG_ONLINE:
              if(OnLineFlag) break;
              else
                {/* try to go on-line */
                 if(GoOnLine(ThePort,Baud19200,Size1024,Size1024))
                   {/* we're online */
                    OnLineFlag = TRUE;
                    SetWindowText(hMainWnd,"SELFTEST: Online @ 19200");
                    CheckMenuItem(hMenu,MSG_OFFLINE,MF_BYCOMMAND | MF_UNCHECKED);
                    CheckMenuItem(hMenu,MSG_ONLINE,MF_BYCOMMAND | MF_CHECKED);
                    for(i=COM1;i<=COM4;i++)
                      EnableMenuItem(hMenu,MSG_COM1+i,MF_BYCOMMAND|MF_GRAYED);
                   }
                }
              break;

            case MSG_OFFLINE:
              if(!OnLineFlag) break;
              GoOffLine(ThePort);
              OnLineFlag = FALSE;
              SetWindowText(hMainWnd,"SELFTEST: Offline");
              CheckMenuItem(hMenu,MSG_ONLINE,MF_BYCOMMAND | MF_UNCHECKED);
              CheckMenuItem(hMenu,MSG_OFFLINE,MF_BYCOMMAND | MF_CHECKED);
              for(i=COM1;i<=COM4;i++)
                EnableMenuItem(hMenu,MSG_COM1+i,MF_BYCOMMAND|MF_ENABLED);
              break;

            case MSG_EXIT:
              DestroyWindow(hMainWnd);
              break;

            case MSG_COM1:
              CheckMenuItem(hMenu,MSG_COM1+ThePort,MF_BYCOMMAND | MF_UNCHECKED);
              ThePort = COM1;
              CheckMenuItem(hMenu,MSG_COM1,MF_BYCOMMAND | MF_CHECKED);
              break;

            case MSG_COM2:
              CheckMenuItem(hMenu,MSG_COM1+ThePort,MF_BYCOMMAND | MF_UNCHECKED);
              ThePort = COM2;
              CheckMenuItem(hMenu,MSG_COM2,MF_BYCOMMAND | MF_CHECKED);
              break;

            case MSG_COM3:
              CheckMenuItem(hMenu,MSG_COM1+ThePort,MF_BYCOMMAND | MF_UNCHECKED);
              ThePort = COM3;
              CheckMenuItem(hMenu,MSG_COM3,MF_BYCOMMAND | MF_CHECKED);
              break;

            case MSG_COM4:
              CheckMenuItem(hMenu,MSG_COM1+ThePort,MF_BYCOMMAND | MF_UNCHECKED);
              ThePort = COM4;
              CheckMenuItem(hMenu,MSG_COM4,MF_BYCOMMAND | MF_CHECKED);
              break;

            default:
              return (DefWindowProc(hMainWnd, message, wParam, lParam));
           }
         break;

    case WM_CREATE:

      /* check "OFFLINE" menu item */
      hMenu = GetMenu(hMainWnd);
      CheckMenuItem(hMenu,MSG_OFFLINE,MF_BYCOMMAND | MF_CHECKED);
      /* check default COM port */
      CheckMenuItem(hMenu,MSG_COM1+ThePort,MF_BYCOMMAND | MF_CHECKED);
      /* create AboutDlgProc() thunk */
      lpProcAbout = MakeProcInstance(AboutDlgProc, hInstance);
      /* initialize paint module */
      InitPaint();
      /* start timer */
      idTimer = SetTimer(hMainWnd,1,125,NULL);
      if(idTimer==0)
         {MessageBox(hMainWnd,"No timers remaining !","ERROR",MB_ICONEXCLAMATION | MB_OK);
          FatalFlag = TRUE;
         }
      break;

    case WM_CHAR:
      SioPutc(ThePort, (char)wParam );
      break;

    case WM_TIMER:
      /* fatal error ? */
      if(FatalFlag) break;
      if(!OnLineFlag) break;
      /* fetch line of up to 1024 chars */
      Count = 0;
      for(i=0;i<1024;i++)
        {TheChar = SioGetc(ThePort,0);
         /* character available ? */
         if(TheChar==-1) break;
         Temp[Count++] = TheChar;
         if((char)TheChar==(char)LF) break;
        } /* end while */
      if(Count>0) WriteTheString(Temp,Count);
      break;

    case WM_SETFOCUS:
      /* create client area caret */
      CreateCaret(hMainWnd,NULL,3,10);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      ShowCaret(hMainWnd);
      break;

    case WM_KILLFOCUS:
      DestroyCaret();
      break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      GoOffLine(ThePort);
      SetWindowText(hMainWnd,"SELFTEST: Offline");
      CheckMenuItem(hMenu,MSG_OFFLINE,MF_BYCOMMAND | MF_CHECKED);
      CheckMenuItem(hMenu,MSG_ONLINE,MF_BYCOMMAND | MF_UNCHECKED);
      if(idTimer) KillTimer(hMainWnd,idTimer);
      PostQuitMessage(0);
      break;

    default:
      return (DefWindowProc(hMainWnd, message, wParam, lParam));
   }
 return (NULL);
} /* end MainWndProc */

void ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {SioError(Code,"Sio Error");
      SioDone(ThePort);
      FatalFlag = TRUE;
     }
} /* end ErrorCheck */
