'
'  Login.BAS Example Program
'

$ERROR ALL ON
$LIB ALL OFF

DEFINT A-Z

$INCLUDE "PCL4PB.BI"
$INCLUDE "MODEM_IO.BI"
$INCLUDE "DEFINES.BI"

$LINK "PCL4PB.OBJ"
$LINK "MODEM_IO.PBU"


 DECLARE FUNCTION MyExit(BYVAL Port AS INTEGER) AS INTEGER

 DECLARE FUNCTION PutGet(BYVAL Port   AS INTEGER, _
                               Send   AS STRING,  _
                         BYVAL Pace   AS INTEGER, _
                               Expect AS STRING,  _
                         BYVAL Tics   AS INTEGER) AS INTEGER

 %FALSE = 0
 %TRUE  = NOT %FALSE
 %CTLZ   = 26
 %ONE.SEC = 18

 'declare variables
 DIM Buffer(256+16) AS BYTE
 DIM BufSeg         AS WORD
 DIM Port           AS INTEGER
 DIM I              AS INTEGER
 DIM L              AS INTEGER
 DIM Code           AS INTEGER
 DIM LibVer         AS INTEGER
 DIM BaudCode       AS INTEGER
 DIM Pace           AS INTEGER
 DIM AnyKey         AS STRING
 DIM RATES(12)      AS STRING
 DIM PARMS          AS STRING
 DIM ARG1           AS STRING
 DIM ARG2           AS STRING

 Pace = 4

 RATES$(1)  = "300"
 RATES$(2)  = "600"
 RATES$(3)  = "1200"
 RATES$(4)  = "2400"
 RATES$(5)  = "4800"
 RATES$(6)  = "9600"
 RATES$(7)  = "19200"
 RATES$(8)  = "38400"
 RATES$(9)  = "57600"
 RATES$(10) = "115200"

 PARMS$ = RTRIM$(COMMAND$)
 I = INSTR(PARMS$, " ")
 IF I < 1 THEN
   PRINT "  Usage: Login <Port> <BaudRate>"
   PRINT "Example: Login 1 9600"
   END 1
 END IF

 L = LEN(PARMS$)
 ARG1$ = LEFT$(PARMS$, I - 1)
 ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
 BaudCode = -1

 'Get COM port
 Port = VAL(ARG1$) - 1

 'Get baud code
 FOR I = 1 TO 10
   IF RATES$(I) = ARG2$ THEN
      BaudCode = I - 1
      EXIT FOR
   END IF
 NEXT I

 'Verify good baud rate
 IF BaudCode = -1 THEN
   PRINT "Cannot recognize baud rate "; ARG2$
   END
 END IF

'Reset port
 BufSeg = 1 + VARSEG(Buffer(0)) + (VARPTR(Buffer(0)) \ 16)
 Code = SioRxBuf(Port, BufSeg, %Size256)
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioRxBuf()"
   Code = SioError(Code)
   END
 END IF
 Code = SioReset(Port, BaudCode)
 CLS
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioReset()"
   Code = SioError(Code)
   END
 END IF

 PRINT "Login 9/25/94"
 PRINT " "
 LibVer = SioInfo(ASC("V"))
 PRINT "Library Version: "; LibVer \ 16; ".";
 PRINT LibVer - 16 * (LibVer \ 16)

 Code = SioDTR(Port, %SET.LINE)
 Code = SioRTS(Port, %SET.LINE)

 IF %AT.COMMAND.SET THEN
   PRINT "ready"
 ELSE
   PRINT "AT.COMMAND.SET must be 1. See DEFINES.BI"
   STOP
 END IF

 'send "AT" to modem & expect "OK" back
 IF PutGet(Port, "!AT!", 5, "OK", 180) = 0 THEN
   Code = MyExit(Port)
 END IF

 'initialize modem & expect "OK" back
 IF PutGet(Port, "AT E1 S7=60 S11=60 V1 X1 Q0 S0=0!", 5, "OK", 90) = 0 THEN
   Code = MyExit(Port)
 END IF

 ' log onto MarshallSoft BBS as GUEST
 Code = PutGet(Port,"!ATDT1,205,880,9748!",Pace,"CONNECT",45*%ONE.SEC)
 IF Code <> 0 THEN Code = PutGet(Port,"!",Pace,"graphics (y/N)?|LAST name:",30*%ONE.SEC)
 IF Code = ASC("0") THEN Code = PutGet(Port,"!",Pace,"LAST name:",10*%ONE.SEC)
 IF Code <> 0 THEN Code = PutGet(Port,"GUEST GUEST!",Pace,"password:",10*%ONE.SEC)
 IF Code <> 0 THEN Code = PutGet(Port,"GUEST!",Pace,"",10*%ONE.SEC)

 'send CR to get prompt
 Code = SioPutc(Port,13)
 PRINT "Entering TERMINAL loop (^Z to quit)..."
 DO
   'Look at incoming serial
   Code = SioGetc(Port, 1)
   IF Code = 13 THEN
     PRINT
   ELSEIF Code >= &H20 THEN
     PRINT CHR$(Code);
   END IF
   'Anything to send
   AnyKey$ = INKEY$
   IF AnyKey$ <> "" THEN Code = SioPutc(Port, ASC(AnyKey$))
   IF AnyKey$ = CHR$(%CTLZ) THEN EXIT DO
 LOOP

 PRINT "User typed Control-Z..."
 Code = MyExit(Port)

 END

 FUNCTION PutGet(BYVAL Port   AS INTEGER, _
                       Send   AS STRING,  _
                 BYVAL Pace   AS INTEGER, _
                       Expect AS STRING,  _
                 BYVAL Tics   AS INTEGER) AS INTEGER

   DIM RC AS INTEGER

   PRINT "*** Sending '";Send;"'";
   IF Expect <> "" THEN
     PRINT " & awaiting '";Expect;"'";
   END IF
   PRINT

   RC = ModemSendTo(Port, Pace, Send)
   PutGet = RC
   IF RC = 0 THEN
     EXIT FUNCTION
   END IF

   IF Expect <> "" THEN
     RC = ModemWaitFor(Port, Tics, %FALSE, Expect)
     IF RC = 0 THEN
       PRINT Expect; " not received"
       PutGet = 0
     ELSE
       PRINT
       PutGet = RC
     END IF
   END IF

END FUNCTION

FUNCTION MyExit(BYVAL Port AS INTEGER) AS INTEGER

   DIM Code AS INTEGER

   Code = SioDone(Port)

END FUNCTION

END
                                                   