/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 *	MicroSoft QuickC: >qcl term.c graphics.lib
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<signal.h>
#include"port.h"

#define NAK 21
#define ACK 6
#define SOH 1
#define EOT 4
#define CAN 24

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)));
	outp(basereg, c);
	}

int follow;

int rcharto(ticks)
	int ticks;
	{
	long tstamp, tstamp1, dayofticksp;
	int c;
	_bios_timeofday(_TIME_GETCLOCK, &tstamp);
	dayofticksp=0;
	while(1)
		{
		if(_bios_timeofday(_TIME_GETCLOCK, &tstamp1))
			dayofticksp+=20*60*60*24;
		if(tstamp1+dayofticksp-tstamp>ticks)
			return(-1); /* NOTE: This is an INT!!! */
		if(follow!=index)
			{
			c=buf[follow++];
			follow=follow%TBUFSIZ;
			return(c);
			}
		}
	}


unsigned char block[128];

sblock(blockn)
	unsigned char blockn;
	{
	int i;
	unsigned char checksum;
	checksum=0;
	sendchar(SOH);
	sendchar(blockn);
	sendchar((blockn^0xff)&0xff);
	for(i=0;i<128;++i)
		{
		sendchar(block[i]);
		checksum+=block[i];
		}
	sendchar(checksum);
	}

quit()
	{
	cleanup();
	exit(99);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	int i, j, infd, ok, c;
	unsigned char blocknum;
	long nbytes;
	index=follow=0;
	printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
	printf("xmodem checksum send of %s.\n", argv[4]);
	if(argc!=5)
		{
		printf("USAGE: xmodemr <comnum> <bps> <stopbits> <file pathname>\n");
		exit(1);
		}
	if((infd=open(argv[4], O_RDONLY|O_BINARY))==-1)
		{
		printf("Error opening file %s.\n", argv[4]);
		exit(2);
		}
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits=argv[3][0];
	setport();
	signal(SIGINT, quit);
	readset();
	setup();
	nbytes=0;
	if(rcharto(2000)!=NAK)
		{
		printf("Spurrious char or no NAK in 100 seconds.\n");
		cleanup();
		exit(10);
		}
	blocknum=1;
	while(1)
		{
		if((j=read(infd, block, 128))==0)
			{
			printf("End of file.\n");
			sendchar(EOT);
			do
				c=rcharto(300);
			while((c!=ACK)&&(c!=NAK)&&(c!=-1));
			if(c!=ACK)
				{
				printf("\nNo ACK of EOT.\n");
				cleanup();
				exit(13);
				}
			else
				{
				printf("\nSuccessful.\n");
				cleanup();
				exit(0);	
				}
			}
		for(c=j;c<128;c++)
			block[c]=26;
		i=0;
		do
			{
			printf("\nSending block %d. ", blocknum);
			sblock(blocknum);
			do
				c=rcharto(200);
			while((c!=ACK)&&(c!=NAK)&&(c!=CAN)&&(c!=-1));
			}
		while((c==NAK)&&(i++<10));
		if(c!=ACK)
			if(c==NAK)
				{
				printf("\nRetry limit exceeded.\n");
				cleanup();
				exit(14);
				}
			else
				{
				printf("\nSpurrious character hex %02x; ACK or NAK expected.\n", c);
				cleanup();
				exit(11);
				}
		nbytes+=128;
		printf("Successful. Bytes so far: %ld", nbytes);
		blocknum++;
		}
	printf("Programming error; fell through end; see code.\n");
	cleanup();
	exit(12);
	}
