/*	Copyright (C) 1992 Peter Edward Cann, all rights reserved.
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<graph.h>
#include"emu.h"
#include"color.h"
#include"port.h"


dispkbd(code)
	unsigned short code;
	{
	int i;
	long tstamp, tstamp1, dayofticksp;
	unsigned char ccode, scode;
	ccode=code&0xff;
	scode=(code>>8)&0xff;
	if(ccode)
		{
		while(!(inp(basereg+STATREG)&0x20));
		outp(basereg, code);
		}
	else
		if(!emu.keys[scode].len)
			putch(0x07);
		else
			for(i=0;i<emu.keys[scode].len;i++)
				{
				while(!(inp(basereg+STATREG)&0x20));
				if(emu.keys[scode].nullpause_p&&!emu.keys[scode].chars[i])
					{
					_bios_timeofday(_TIME_GETCLOCK, &tstamp);
					dayofticksp=0;
					while(1)
						{
						if(_bios_timeofday(_TIME_GETCLOCK, &tstamp1))
							dayofticksp+=20*60*60*24;
						if(tstamp1+dayofticksp-tstamp>22)
							break;
						}
					}
				else if(emu.keys[scode].nullpause_p&&(emu.keys[scode].chars[i]==0xff))
					{
					_bios_timeofday(_TIME_GETCLOCK, &tstamp);
					outp(basereg+LCTLREG, lctl|0x40);
					dayofticksp=0;
					while(1)
						{
						if(_bios_timeofday(_TIME_GETCLOCK, &tstamp1))
							dayofticksp+=20*60*60*24;
						if(tstamp1+dayofticksp-tstamp>10)
							break;
						}
					outp(basereg+LCTLREG, lctl);
					}
				else
					outp(basereg, emu.keys[scode].chars[i]);
				}
	}

#define LISTSIZ 16

struct
	{
	short index;
	short row;
	short column;
	short list[LISTSIZ];
	short listindex;
	}
	funcstor[NFUNCS];

clrfuncstor(seqn)
	short seqn;
	{
	int i;
	for(i=funcstor[seqn].listindex-1;i>=0;i--)
		funcstor[seqn].list[i]=0;
	funcstor[seqn].row=funcstor[seqn].column=funcstor[seqn].listindex=funcstor[seqn].index=0;
	}

int bold, faint, blink, inverse, bkcolor, fgcolor;
struct videoconfig far *vconf;

atthndl()
	{
	int adds, workingbk, workingfg;
	adds=0;
	if(vconf->adapter!=_MDPA)
		{
		workingbk=bkcolor;
		workingfg=fgcolor;
		if(faint)
			if(inverse)
				if(bkcolor==WHITE)
					workingbk=GRAY;
				else
					adds+=FAINTADD;
			else
				if(fgcolor==WHITE)
					workingfg=GRAY;
				else
					adds+=FAINTADD;
		else
			if(bold)
				{
				if(bkcolor==WHITE)
					workingbk=BWHITE;
				if(fgcolor==WHITE)
					workingfg=BWHITE;
				}
		if(blink)
			adds+=BLINKADD;
		if(inverse)
			{
			if(blink)
				_settextcolor(workingbk+BLINKADD);
			else
				_settextcolor(workingbk);
			if(faint)
				_setbkcolor((long)(workingfg+FAINTADD));
			else
				_setbkcolor((long)workingfg);
			}
		else
			{
			_settextcolor(workingfg+adds);
			_setbkcolor((long)workingbk);
			}
		}
	else
		{
		workingbk=BLACK;
		if(bold&&!inverse)
			workingfg=M_UNDER;
		else
			if(inverse)
				workingfg=WHITE;
			else
				workingfg=M_NORMAL;
		if(faint)
			adds+=FAINTADD;
		if(blink)
			adds+=BLINKADD;
		if(inverse)
			{
			if(blink)
				_settextcolor(workingbk+BLINKADD);
			else
				_settextcolor(workingbk);
			_setbkcolor((long)workingfg);
			}
		else
			{
			_settextcolor(workingfg+adds);
			_setbkcolor((long)workingbk);
			}
		}
	}


ansiatthndl(seqn)
	short seqn;
	{
	int i, adds, workingbk, workingfg;
	if(emu.funcs[seqn].func==ANSIATTRIB)
		for(i=0;i<funcstor[seqn].listindex;i++)
			switch(funcstor[seqn].list[i])
				{
				/*at the moment this is strictly ANSI subset*/
				case 0:
					bkcolor=BLACK;
					fgcolor=WHITE;
					bold=faint=blink=inverse=0;
					break;
				case 1:
					bold=1;
					break;
				case 2:
					faint=1;
					break;
				case 5:
				case 6:
					blink=1;
					break;
				case 7:
					inverse=1;
					break;
				case 8:
				case 30:
				case 40:
					fgcolor=bkcolor;
					break;
				case 31:
				case 41:
					fgcolor=RED;
					break;
				case 32:
				case 42:
					fgcolor=GREEN;
					break;	
				case 33:
				case 43:
					fgcolor=YELLOW;
					break;
				case 34:
				case 44:
					fgcolor=BLUE;
					break;
				case 35:
				case 45:
					fgcolor=MAGENTA;
					break;
				case 36:
				case 46:
					fgcolor=CYAN;
					break;
				case 37:
				case 47:
					fgcolor=WHITE;
					break;
				default:
					break;
				}
	atthndl();
	}

int wrap_p;

wrapctl()
	{
	if(wrap_p)
		_wrapon(_GWRAPON);
	else
		_wrapon(_GWRAPOFF);
	}

char fpname[256], dribpname[256];

updstatus()
	{
	struct rccoord posptr;
	short tc;
	long bc;
	char str[80];
	posptr=_gettextposition();
	tc=_gettextcolor();
	bc=_getbkcolor();
	_settextwindow(1,1,1,80);
	_settextposition(1,1);
	_settextcolor(BLACK);
	_setbkcolor((long)WHITE);
	_wrapon(_GWRAPOFF);
	sprintf(str, "Both Shifts to Exit COM%u %5u %c%c%c %22s %22s",
		comnum+1, speed, databits, parity, stopbits, fpname, dribpname);
	_outtext(str);
	_settextwindow(2,1,25,80);
	wrapctl();
	_settextcolor(tc);
	_setbkcolor(bc);
	_settextposition(posptr.row, posptr.col);
	}

int graphics;

showchar(c)
	char c;
	{
	char str[2];
	if(graphics)
		if(emu.gchars[c])
			c=emu.gchars[c];
	str[0]=c;
	str[1]='\0';
	_outtext(str);
	}

perffunc(seqn)
	short seqn;
	{
	struct rccoord posptr;
	int i;
	switch(emu.funcs[seqn].func)
		{
		case CLEAR:
			_clearscreen(_GCLEARSCREEN);
			updstatus();
			_settextposition(1,1);
			break;
		case HOME:
			_settextposition(1,1);
			break;
		case CLREOL:
			posptr=_gettextposition();
			_wrapon(_GWRAPOFF);
			for(i=posptr.col;i<=80;i++)
				_outtext(" ");
			_settextposition(posptr.row, posptr.col);
			wrapctl();
			break;
		case UP:
			posptr=_gettextposition();
			if(posptr.row>1)
				_settextposition(posptr.row-1, posptr.col);
			break;
		case DOWN:
			posptr=_gettextposition();
			if(posptr.row<24)
				_settextposition(posptr.row+1, posptr.col);
			else
				{
				showchar('\n');
				_settextposition(posptr.row, posptr.col);
				}
			break;
		case LEFT:
			posptr=_gettextposition();
			if(posptr.col>1)
				_settextposition(posptr.row, posptr.col-1);
			break;
		case RIGHT:
			posptr=_gettextposition();
			if(posptr.col<80)
				_settextposition(posptr.row, posptr.col+1);
			break;
		case GOTO:
			if(funcstor[seqn].row<1)
				funcstor[seqn].row=1;
			if(funcstor[seqn].row>24)
				funcstor[seqn].row=24;
			if(funcstor[seqn].column<1)
				funcstor[seqn].column=1;
			if(funcstor[seqn].column>80)
				funcstor[seqn].row=80;
			_settextposition((emu.tophi_p?25-funcstor[seqn].row:funcstor[seqn].row), funcstor[seqn].column);
			break;
		case NORMAL:
			fgcolor=WHITE;
			bkcolor=BLACK;
			blink=faint=bold=inverse=0;
			atthndl();
			break;
		case BLINK:
			blink=1;
			atthndl();
			break;
		case NOBLINK:
			blink=0;
			atthndl();
			break;
		case BOLD:
			bold=1;
			atthndl();
			break;
		case NOBOLD:
			bold=0;
			atthndl();
			break;
		case FAINT:
			faint=1;
			atthndl();
			break;
		case NOFAINT:
			faint=0;
			atthndl();
			break;
		case INVERSE:
			inverse=1;
			atthndl();
			break;
		case NOINVERSE:
			inverse=0;
			atthndl();
			break;
		case UPN:
			posptr=_gettextposition();
			if(posptr.row-funcstor[seqn].row<1)
				_settextposition(1, posptr.col);
			else
				_settextposition(posptr.row-funcstor[seqn].row, posptr.col);
			break;
		case DOWNN:
			posptr=_gettextposition();
			if(posptr.row+funcstor[seqn].row>24)
				{
				_settextposition(24,1);
				for(i=25-(posptr.row+funcstor[seqn].row);i<0;++i)
					showchar('\n');
				_settextposition(24, posptr.col);
				}
			else
				_settextposition(posptr.row+funcstor[seqn].row, posptr.col);
			break;
		case LEFTN:
			posptr=_gettextposition();
			if(posptr.col-funcstor[seqn].column<1)
				_settextposition(posptr.row, 1);
			else
				_settextposition(posptr.row, posptr.col-funcstor[seqn].column);
			break;
		case RIGHTN:
			posptr=_gettextposition();
			if(posptr.col+funcstor[seqn].column>80)
				_settextposition(posptr.row, 80);
			else
				_settextposition(posptr.row, posptr.col+funcstor[seqn].column);
			break;
		case ANSIATTRIB:
			ansiatthndl(seqn);
			break;
		case WRAP:
			wrap_p=1;
			wrapctl();
			break;
		case NOWRAP:
			wrap_p=0;
			wrapctl();
			break;
		case GOTOLINE:
			posptr=_gettextposition();
			if(funcstor[seqn].row<1)
				funcstor[seqn].row=1;
			if(funcstor[seqn].row>24)
				funcstor[seqn].row=24;
			_settextposition(emu.tophi_p?25-funcstor[seqn].row:funcstor[seqn].row, posptr.col);
			break;
		case GOTOCOL:
			posptr=_gettextposition();
			if(funcstor[seqn].column<1)
				funcstor[seqn].column=1;
			if(funcstor[seqn].column>80)
				funcstor[seqn].row=80;
			_settextposition(posptr.row, funcstor[seqn].column);
			break;
		case WYSEATTR:
			if(funcstor[seqn].row&0x02)
				blink=1;
			else
				blink=0;
			if(funcstor[seqn].row&0x04)
				inverse=1;
			else
				inverse=0;
			if(funcstor[seqn].row&0x08)
				bold=1;
			else
				bold=0;
			if(funcstor[seqn].row&0x40)
				faint=1;
			else
				faint=0;
			atthndl();
			break;
		case GRAPHCHAR:
			showchar(emu.gchars[funcstor[seqn].row]);
			break;
		case BEGGRAPH:
			graphics=1;
			break;
		case ENDGRAPH:
			graphics=0;
			break;
		case TAB:
			posptr=_gettextposition();
			_settextposition(posptr.row, posptr.col+(8-((posptr.col-1)%8)));
			break;
		case BELL:
			putch(7);
			break;
		case DTAB:
			posptr=_gettextposition();
			for(i=0;i<(8-((posptr.col-1)%8));++i)
				_outtext(" ");

		default:
			break;
		}
	}

dispport(c)
	unsigned char c;
	{
	int seqn, done, ok;
	done=0;
	ok=0;
	for(seqn=0;seqn<NFUNCS;seqn++)
		{
		if(emu.funcs[seqn].codes[funcstor[seqn].index]&0xff00)
			switch(emu.funcs[seqn].codes[funcstor[seqn].index])
				{
				case END:
					if(funcstor[seqn].index)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case BINCOL:
					funcstor[seqn].column=c-emu.bincoloff;
					ok=1;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case BINROW:
					funcstor[seqn].row=c-emu.binrowoff;
					ok=1;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case ASCDECCOL:
					if((c>='0')&&(c<='9'))
						{
						ok=1;
						funcstor[seqn].column*=10;
						funcstor[seqn].column+=(c-'0');
						}
					else
						if(c==emu.funcs[seqn].codes[++funcstor[seqn].index])
							{
							ok=1;
							if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
								{
								done=1;
								perffunc(seqn);
								}
							}
						else
							clrfuncstor(seqn);
					break;
				case ASCDECROW:
					if((c>='0')&&(c<='9'))
						{
						ok=1;
						funcstor[seqn].row*=10;
						funcstor[seqn].row+=(c-'0');
						}
					else
						if(c==emu.funcs[seqn].codes[++funcstor[seqn].index])
							{
							ok=1;
							if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
								{
								done=1;
								perffunc(seqn);
								}
							}
						else
							clrfuncstor(seqn);
					break;
				case ASCDECSEMILIST:
					if((c>='0')&&(c<='9'))
						{
						ok=1;
						funcstor[seqn].list[funcstor[seqn].listindex]*=10;
						funcstor[seqn].list[funcstor[seqn].listindex]+=(c-'0');
						}
					else
						{
						if(funcstor[seqn].listindex<LISTSIZ)
							funcstor[seqn].listindex++;
						
						if(c==';')
							ok=1;
						else
							if(c==emu.funcs[seqn].codes[++funcstor[seqn].index])
								{
								ok=1;
								if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
									{
									done=1;
									perffunc(seqn);
									}
								}
							else
								clrfuncstor(seqn);
						}
					break;
				case GRABCHAR:
					ok=1;
					funcstor[seqn].row=c;
					if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
						{
						done=1;
						perffunc(seqn);
						}
					break;
				case GRAPHCHAR_T:
					if(emu.gchars[c])
						{
						ok=1;
						funcstor[seqn].row=c;
						if(emu.funcs[seqn].codes[funcstor[seqn].index]==END)
							{
							done=1;
							perffunc(seqn);
							}
						}
					else
						clrfuncstor(seqn);
					break;
				}
		else
			if(c==emu.funcs[seqn].codes[funcstor[seqn].index])
				{
				ok=1;
				if(emu.funcs[seqn].codes[++funcstor[seqn].index]==END)
					{
					done=1;
					perffunc(seqn);
					}
				}
			else
				clrfuncstor(seqn);
		if(done)
			{
			ok=1;
			for(seqn=0;seqn<NFUNCS;seqn++)
				clrfuncstor(seqn);
			break;
			}
		}
	if(!ok)
		showchar(c);
	}

initdisp()
	{
	int i;
	for(i=0;i<NFUNCS;i++)
		{
		funcstor[i].listindex=LISTSIZ;
		clrfuncstor(i);
		}
	bold=faint=blink=inverse=0;
	fgcolor=WHITE;
	bkcolor=BLACK;
	graphics=0;
	wrap_p=emu.default_wrap_p;
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	FILE *dribble;
	char c;
	int follow, emufd, i, orun;
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run TERM? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("I didn't think so!\n");
			exit(99);
			}
		else
			printf("OK, you're the boss!\n");
		}
	_getvideoconfig(vconf);
	index=follow=0;
	if((argc<4)||(argc>6))
		{
		printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
		printf("USAGE: term <comnum> <bps> <data><parity><stop> [<emu or - >] [<dribble>]\n");
		printf("<emu> is an emulation file base pathname.\n");
		printf("<dribble> is a dribble (text capture) file.\n");
		printf("The environment variable PCCPPATH is used for the emulation file if set.\n");
		exit(1);
		}
	fpname[0]='\0';
	dribpname[0]='\0';
	if((argc>=5)&&(argv[4][0]!='-'))
		{
		if((getenv("PCCPPATH")==NULL)||(argv[4][0]=='\\')||(argv[4][1]==':'))
			sprintf(fpname, "%s.emu", argv[4]);
		else
			sprintf(fpname, "%s\\%s.emu", getenv("PCCPPATH"), argv[4]);
		if((emufd=open(fpname, O_RDONLY|O_BINARY))==-1)
			{
			printf("Error opening emulation file %s.\n", fpname);
			exit(2);
			}
		else
			if(read(emufd, &emu, sizeof(emu))!=sizeof(emu))
				{
				printf("Error reading emulation file %s.\n", fpname);
				exit(3);
				}
			else;
		}
	else
		{
		nullemu();
		emu.funcs[0].func=LEFT;
		emu.funcs[0].codes[0]='\b';
		emu.funcs[0].codes[1]=END;
		emu.funcs[1].func=DTAB;
		emu.funcs[1].codes[0]='\t';
		emu.funcs[1].codes[1]=END;
		emu.funcs[2].func=BELL;
		emu.funcs[2].codes[0]='\007';
		emu.funcs[2].codes[1]=END;
		}
	if(argc==6)
		{
		strcpy(dribpname, argv[5]);
		if((dribble=fopen(argv[5], "a"))==NULL)
			{
			printf("Couldn't open dribble file %s.\n");
			exit(10);
			}
		else
			fprintf(dribble, "\nBeginning of dribble segment.\n\n");
		}
	else
		dribble=NULL;
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	parity=argv[3][1];
	databits=argv[3][0];
	stopbits=argv[3][2];
	setport();
	readset();
	setup();
	_clearscreen(_GCLEARSCREEN);
	initdisp();
	updstatus();
	atthndl();
	_settextposition(1,1);
	orun=0;
	while(1)
		{
		if((_bios_keybrd(_KEYBRD_SHIFTSTATUS) & 3) == 3)
			{
			cleanup();
			_settextcolor(WHITE);
			_setbkcolor((long)BLACK);
			if(dribble!=NULL)
				{
				fprintf(dribble, "\nEnd of dribble segment.\n");
				fclose(dribble);
				}
			_outtext("\nOrderly exit from TERM.\n");
			exit(0);
			}
		if(_bios_keybrd(_KEYBRD_READY))
			dispkbd(_bios_keybrd(_KEYBRD_READ));
		if(follow!=index)
			{
			if(dribble!=NULL)
				fputc(buf[follow], dribble);
			/* We only display if we're not too far behind; */
			/* this makes dribble more reliable. */
			if(((index-follow)>4096)||(((index-follow)<0)&&((follow-index)<4096)))
				if(!orun)
					{
					orun=1;
					initdisp();
					}
				else;
			else
				{
				orun=0;
				dispport(buf[follow]);
				}
			follow++;
			follow=follow%TBUFSIZ;
			}
		}
	}
