;********* EndStr.Asm

;Compares end of string against another string - returns true if it matches
;

;Syntax: DECLARE FUNCTION EndString(St$, EndCh$)
;
;        St$     is the String to check the end of
;        EndCh$  is the string to test for

.Model Medium
.Code
Include Mixed.Inc

hProc EndString String:Ptr, Endch:Ptr
    Cld                         ;clear direction for string compares
    Push   ES
    Push   DS                   ;align segments for string compares
    Pop    ES
    Xor    AX,AX                ;Assume they don't match

    Mov    BX,String            ;use BX for the address of St$ descriptor
    Mov    CX,[BX]              ;AX holds LEN(St$)
    Mov    DI,[BX+2]            ;DI holds first character of St$
    Jcxz   Exit ;Match          ;get out if zero  (Maybe need to pretend they match)
    Mov    DX,CX                ;now DX holds LEN(St$)
    Add    DI,CX                ;Point to End of String+1

    Mov    BX,EndCh             ;use BX for the address of EndCh$ descriptor
    Mov    CX,[BX]              ;CX holds LEN(EndCh$)
    Mov    SI,[BX+2]            ;SI holds first character of EndCh$
    Jcxz   Exit                 ;get out if zero
    Sub    DI,CX                ;Back up length of EndCh$

    Cmp    DX,CX                ;compare LEN(St$) to LEN(EndCh$)
    Jb     Exit                 ;If Shorter then get out

    Repe   Cmpsb                ;compare 'til we find a non-match or run out
    Jne    Exit                 ;If they didn't match get out
Match:
    Dec    AX                   ;Else show that they did
Exit:
    Pop    ES
    HRet                  ; Return to BASIC

hEndP
End
