'EDIT.BAS - for PB-Tools and PowerBASIC
'Written by Dave Navarro, Jr.

'Edit$ - Get ASCII input from user
' the default string is displayed, if the user starts inputing something
' without backing up, the line is cleared for the new input.

FUNCTION Edit$(Default$, MaxLen%, FilChar$) PUBLIC
   Text$=Default$
   CALL InsertOff
   FilChar%=ASCII(FilChar$)
   IF FilChar%<0 THEN FilChar%=32
   Col%=POS(0)
   Row%=CSRLIN
   IF LEN(Text$)>MaxLen% THEN EXIT FUNCTION
   Tmp$=""
   TopScan%=CurTop%
   BotScan%=CurBot%
   LOCATE Row%, Col%,0
   PRINT STRING$(Maxlen%,FilChar%);
   LOCATE Row%, Col%,1,TopScan%,BotScan%
   PRINT Text$;
   CPos%=LEN(Text$)
   Ins%=InsStat%
   StartOut:
      I$=GetKey$
      IF I$=CHR$(8) THEN Tmp$=Text$:GOTO BackSpace
      IF I$=CHR$(0,75) AND Text$>"" THEN          'Left Arrow
        Tmp$=Text$
        DECR CPos%
        GOTO GetText
      END IF
      IF I$=CHR$(0,71) THEN                       'Home Key
        Tmp$=Text$
        CPos%=0
        GOTO GetText
    END IF
    IF I$=CHR$(13) THEN SayBye                    'Return
    IF I$=CHR$(27) THEN SayBye                    'Esc
      IF I$=CHR$(0,72) THEN SayBye                'Down Arrow
      IF I$=CHR$(0,80) THEN SayBye                'Up Arrow
      IF IsASCII%(I$)=0 THEN StartOut
      LOCATE Row%, Col%
      PRINT STRING$(MaxLen%,FilChar%);
      Tmp$=I$
      CPos%=1
   GetText:
      LOCATE Row%, Col%, 0
      PRINT Tmp$;
      LOCATE Row%, Col%+CPos%, 1, TopScan%, BotScan%
      I$=GetKey$
      IF I$=CHR$(8) THEN BackSpace                         'back space
      IF I$=CHR$(0,82) AND Ins%=0 THEN                     'insert key
        Ins%=-1
        DECR TopScan%,2
        GOTO GetText
      END IF
      IF I$=CHR$(0,82) AND Ins%=-1 THEN                    'insert key
        Ins%=0
        INCR TopScan%,2
        GOTO GetText
      END IF
      IF I$=CHR$(0,79) THEN CPos%=LEN(Tmp$)                'end key
      IF I$=CHR$(0,71) THEN CPos%=0                        'home key
      IF I$=CHR$(0,83) AND CPos%<LEN(Tmp$) THEN DelKy      'delete
      IF I$=CHR$(0,75) AND CPos%>0 THEN DECR CPos%         'left arrow
      IF I$=CHR$(0,77) AND CPos%<LEN(Tmp$) THEN INCR CPos% 'right arrow
      IF I$=CHR$(27) THEN Text$=Default$:GOTO SayBye       'esc key
      IF I$=CHR$(0,80) THEN Text$=Tmp$:GOTO SayBye         'down arrow
      IF I$=CHR$(0,72) THEN Text$=Tmp$:GOTO SayBye         'up arrow
      IF I$=CHR$(13) THEN Text$=Tmp$:GOTO SayBye           'return
      IF IsASCII%(I$)=0 THEN GetText
      IF LEN(Tmp$)=MaxLen% THEN GetText
      IF LEN(Tmp$)=Cpos% THEN
        Tmp$=Tmp$+I$
       ELSEIF Ins%=-1 THEN
        Tmp$=InsChar$(Tmp$,I$,CPos%)
       ELSE
        MID$(Tmp$,CPos%+1,1)=I$
      END IF
      INCR CPos%
      GOTO GetText
  BackSpace:
      IF Tmp$="" OR CPos%=0 THEN GetText
      IF CPos%=LEN(Tmp$) THEN
        Tmp$=LEFT$(Tmp$, LEN(Tmp$)-1)
       ELSE
        Tmp$=DelChar$(Tmp$,CPos%)
      END IF
      LOCATE Row%, Col%, 0
      PRINT Tmp$;CHR$(FilChar%);
      DECR CPos%
      GOTO GetText
  DelKy:
      IF LEN(Tmp$)=1 THEN
        Tmp$=""
       ELSE
        Tmp$=DelChar$(Tmp$,CPos%+1)
      END IF
      LOCATE Row%, Col%, 0
      PRINT Tmp$;CHR$(FilChar%);
      GOTO GetText
  SayBye:
      IF Ins%=-1 THEN INCR TopScan%,2
      CALL InsertOff
      LOCATE Row%, Col%, 0, TopScan%, BotScan%
      PRINT Text$;STRING$(MaxLen%-LEN(Text$),FilChar%);
      FilChar$=I$   'return the terminator in FilChar$
      Edit$=Text$   'give them the altered text without changing the original
END FUNCTION

'GetKey - Loop until a key is pressed and return the key to your program

FUNCTION Getkey$ PUBLIC
   WHILE I$=""
      I$=INKEY$
   WEND
   Getkey$=I$
END FUNCTION

'IsASCII% - Tests if a charactor is a printable ASCII charactor

FUNCTION IsASCII%(I$) PUBLIC
   IF ASCII(I$)>31 AND ASCII(I$)<127 THEN IsASCII%=-1 ELSE IsASCII%=0
END FUNCTION

'DelChar - Delete a charactor from a string

FUNCTION DelChar$(Tmp$,Xpos%) PUBLIC
   DelChar$=LEFT$(Tmp$,Xpos%-1)+MID$(Tmp$,Xpos%+1)
END FUNCTION

'InsChar - Insert a charactor into a string

FUNCTION InsChar$(Tmp$,Tmp2$,Xpos%) PUBLIC
   InsChar$=LEFT$(Tmp$,Xpos%)+Tmp2$+MID$(Tmp$,Xpos%+1)
END FUNCTION

'CurTop - Returns the top scan line of cursor

FUNCTION CurTop% PUBLIC
   DEF SEG=&H0040
   CurTop%=PEEK(&H0061) AND &HF
   DEF SEG
END FUNCTION

'CurBot - Returns the bottom scan line of cursor

FUNCTION CurBot% PUBLIC
   DEF SEG=&H0040
   CurBot%=PEEK(&H0060)
   DEF SEG
END FUNCTION

'InsertOn - toggle insert key status

SUB InsertOn STATIC PUBLIC
   DEF SEG = 0
   POKE &H417,PEEK(&H417) OR 128
   DEF SEG
END SUB

'InsertOff - toggle insert mode off

SUB InsertOff STATIC PUBLIC
   DEF SEG = 0
   POKE &H417,PEEK(&H417) AND 127
   DEF SEG
END SUB
