/* REXX file to install the Pastry Box on the deskop     */
/* if you use this script as a starting point for your   */
/* own install script and make improvements, please send */
/* me a copy ---  dwhawk@southwind.net                   */

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs                /* register system functions */
address cmd '@echo off'          /* echo is turned off */

call SysCLS

say "Pastry Box installation"
say "Enter destination drive and directory"
say "for example C:\OS2\APPS"
say "to install in the curent directory just press enter"

pull dest
call setup_dir(dest) 
call copy_files
call MKOBJ
exit

check_ok:
  say  'Okay to continue(Y/n) ? '        
  k = SysGetKey('NOECHO') 
  if k = 'Y' | k = 'y'  then return
  say 'halting'
    exit
  end


mkdir:  /* Procedure for creating dir */
  Parse Arg dir
  rc = SysMkDir(dir)
  If (rc = 0 | rc = 5) Then Return
  Say 'Problem creating destination directory "'dir'"'
  Exit


MKOBJ:
Settings = 'EXENAME='direct||'\Pastry.exe;'
Settings = Settings||'PROGTYPE=PM;MINIMIZED=NO;'
Settings = Settings||'ICONFILE='direct||'\Pastry.ICO;'
Settings = Settings||'CCVIEW=YES;'
Settings = Settings||'STARTUPDIR='||direct';'
rc=SysCreateObject('WPProgram','Pastry Box','<WP_DESKTOP>',Settings,'R');

if rc = 1 then Say "Pastry Box installed on desktop"
return
end

setup_dir:      /* accept install path and create it if needed */
                /* the desired install path is in ARG(1) */
                /* if no path is specified current directory is used*/

Parse Arg destin  /* parameter of setup_dir */

save_dest = destin    /*  save original destin to */
                      /*  determine if copy needed */

If destin = "" Then destin = Directory()

Say "Shall I install in "destin" ?"
Call Check_Ok  /* your check routine */

Parse Var destin direct ':\' destin   /* get drive name only */
direct=direct':'

Do Until destin = ""     /* No matter how many sub dirs present */
  Parse Var destin sub '\' destin
  direct=direct'\'sub
  Call mkdir direct
End
return

copy_files:
if save_dest \= ""  then do
   'COPY LICENSE.TXT ' direct
   'COPY ORDER.BMT   ' direct
   'COPY PASTRY.EXE  ' direct
   'COPY PASTRY.ICO  ' direct
   'COPY PASTRY2.DOC ' direct
   'COPY READ.ME     ' direct
end
return
end
