/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termint.h"
#include "_termctl.h"
#include "utils.h"

#ifndef PB_SDK
	#include <ctype.h>
#else
	#include "pblibc.h"
#endif

/*
 * p r o b o a r d   c o l o r   c o d e   s y s t e m
 * 
 * this implements the '\\' color code system used in the proboard language
 * files. it does not support the '^' color toggle code.
*/
Boolean
proboard_interp::init( uchar aSOS )
{
	Boolean retval = False;

	if( '\\' == aSOS )
	{
		term_interp::init(aSOS);
		retval = True;
	}

	return retval;
}

void
proboard_interp::handle( uchar aChar )
{
	int attrib = 0;

	if( 2 == m_buff->getCount() )
	{ // end of sequence
		switch( toupper(m_buff->bp()[1]) )
		{
			case 'H': attrib = 8; /* fall-through */
			case 'L':
				switch( toupper(aChar) ){
					case 'R': attrib += 4; break; // red
					case 'G': attrib += 2; break; // green
					case 'Y': attrib += 6; break; // yellow
					case 'B': attrib += 1; break; // blue
					case 'P': attrib += 5; break; // magenta
					case 'C': attrib += 3; break; // cyan
					case 'W': attrib += 7; break; // grey
					default :
						m_buff->put(aChar);
						m_fail = True;
						return;
				}
				m_ctrl->set_color(attrib);
				m_eos = True;
				break;

			default:
				if( isxdigit(m_buff->bp()[1]) && isxdigit(aChar) )
				{
					m_ctrl->set_color(hexColor(m_buff->bp()[1], aChar));
					m_eos = True;
				}
				else
				{
					m_buff->put(aChar);
					m_fail = True;
				}
		}
	}
	// special case to handle the backslash
	else if( 1 == m_buff->getCount() && '\\' == aChar )
	{
		m_ctrl->put('\\');
		m_eos = True;
	}
	// other characters are stuffed in
	else m_buff->put(aChar);
}
