/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termint.h"
#include "_termctl.h"
#include "utils.h"

#ifndef PB_SDK
	#include <ctype.h>
#else
	#include "pblibc.h"
#endif

/*
 * h e x p i p e   c o l o r   i m p l e m e n t a t i o n
 * 
 * this implements the common |xx color code specification (hex pipes). note
 * that these are different from the Renegade color system!
*/
Boolean
hexpipe_interp::init( uchar aSOS )
{
	Boolean retval = False;

	if( '|' == aSOS )
	{
		term_interp::init(aSOS);
		retval = True;
	}

	return retval;
}

void
hexpipe_interp::handle( uchar aChar )
{
	if( 2 == m_buff->getCount() )
	{ // end of sequence
		if( isxdigit(m_buff->bp()[1]) && isxdigit(aChar) )
		{
			m_ctrl->set_color(hexColor(m_buff->bp()[1], aChar));
			m_eos = True;
		}
		else
		{
			m_buff->put(aChar);
			m_fail = True;
		}
	}
	else if( '|' == aChar )
	{ // special sequence (display a pipe)
		m_ctrl->put(aChar);
		m_eos = True;
	}
	else m_buff->put(aChar);
}
