/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termbuf.h"
#include "_termctl.h"

#ifndef PB_SDK
	#include <stdio.h>
#else
	#include "pblibc.h"
#endif

term_buff::term_buff(size_t aSize)
	:m_buf(new char [aSize])
	,m_size(aSize)
	,m_pos(0)
	,m_term(0)
{
}

term_buff::term_buff(const term_buff &buf)
	:m_buf(new char [buf.m_size])
	,m_size(buf.m_size)
	,m_pos(buf.m_pos)
	,m_term(buf.m_term)
{
}

term_buff::~term_buff()
{
	if( m_buf ) delete[] m_buf;
}

void
term_buff::put(char aChar)
{
	if( m_pos >= m_size ) flush();
	m_buf[m_pos++] = aChar;
}

int
term_buff::get()
{
	if( m_pos ) return m_buf[--m_pos];
	else return EOF;
}

void
term_buff::flush()
{
	if( m_term )
	{
		m_term->put(m_buf, m_pos);
	}
	m_pos = 0;
}