/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "str.h"

/*
 * converts tabs to spaces in string s, tab width is n, returns a new
 * string, with tabs expanded. this string must be deallocated by the caller
*/
char*
strtts( const char *s, int n )
{
	char *p, *ptr;
	int  i;
	size_t num_t;

	for( p = (char *)s, num_t = 0; *p; ++p )
		if( '\t' == *p ) num_t++;

	ptr = (char *)malloc( strlen(s) + (num_t * (n - 1)) + 1 );
	if( !ptr ) return NULL;

	for( p = ptr; *s; ){
		if( '\t' == *s ){
			s++;
			for( i = 0; i < n; ++i ) *p++ = ' ';
		}
		else *p++ = *s++;
	}
	*p = EOS;

	return ptr;
}

