/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "slist.h"

zSingleList::zSingleList(Boolean shouldDelete)
{
	cpos = count = 0L;
    purge = shouldDelete;
    tail = focus = 0;
}

zSingleList::~zSingleList()
{
	while( count ) unlink();
}

ushort
zSingleList::firstThat(fpTestFunc test, void *arg)
{
	if( count ){
    	begin();
        do{
        	if( test(focus->data, arg) ) return 1;
		}while( next() );
	}
    return 0;
}

void
zSingleList::forEach(fpAppFunc action, void *arg)
{
	if( count ){
		begin();
        do{
        	action(focus->data, arg);
		}while( next() );
	}
}

ushort
zSingleList::append(void *data)
{
    if( link(data) ){
    	tail = tail->next;
        return 1;
	}
    return 0;
}

ushort
zSingleList::begin()
{
	if( count ){
    	focus = tail->next;
        cpos = 1L;
    	return 1;
	}
    return 0;
}

ushort
zSingleList::end()
{
	if( count && !atEnd() ){
    	focus = tail;
        cpos = count;
    	return 1;
	}
    return 0;
}

ushort
zSingleList::link(void *data)
{
	zSLNode *node = new zSLNode(data);

    if( !node ){
		err = 1;
        return 0;
	}

    if( !count ) tail = node;
    else node->next = tail->next;
    tail->next = node;

    cpos++;
    count++;
    focus = node;
    return 1;
}

ushort
zSingleList::next()
{
	if( count && !atEnd() ){
    	focus = focus->next;
        cpos++;
        return 1;
	}
    return 0;
}

ushort
zSingleList::operator+=(ushort nelem)
{
	for( ; nelem; --nelem ){
    	if( atEnd() ) return 0;
    	focus = focus->next;
        cpos++;
    }
    return 1;
}

ushort
zSingleList::unlink()
{
	if( count ){
		zSLNode *temp = tail->next;
        tail->next = tail->next->next;
        if( purge ) freeData(temp->data);
        delete temp;
        if( atStart() ) focus = tail->next;
        count--;
    	return 1;
	}
    return 0;
}

ushort
zSingleList::update(void *data)
{
	if( count ){
    	focus->data = data;
		return 1;
	}
    return 0;
}
