/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblsdk.h"
#include "comdef.h"

#ifndef PB_SDK
	#include <string.h>
#endif

#define MAX_TAGS 200

class _tag
{
	friend short GetTaggedFiles(TAGGED_FILE*, short);
	friend BOOL  PutTaggedFile(TAGGED_FILE*, short);
	friend BOOL  AddTaggedFile(TAGGED_FILE *);
	friend BOOL  RemoveTaggedFile(TAGGED_FILE *);
	friend void  RemoveTaggedFiles();
	friend BOOL  IsTagged(TAGGED_FILE*);
	friend void  ClearTaggedFiles();

	static short       find(TAGGED_FILE*);
	static short       m_Count;
	static TAGGED_FILE m_tag[MAX_TAGS];
};

short       _tag::m_Count = 0;
TAGGED_FILE _tag::m_tag[MAX_TAGS];

short
_tag::find( TAGGED_FILE *tag )
{
	for( int i = 0; i < m_Count; ++i )
		if( m_tag[i].area == tag->area && !strcmp(m_tag[i].name, tag->name) )
			return i;
	return -1;
}

short
GetTaggedFiles(TAGGED_FILE *array, short nMax)
{
	short n = min(_tag::m_Count, nMax);
	memcpy(array, _tag::m_tag, n * sizeof(TAGGED_FILE));
	return n;
}

BOOL
PutTaggedFiles(TAGGED_FILE *array, short n)
{
	for( int i = 0; i < n; ++i ){
		if( !AddTaggedFile(&array[i]) ) return FALSE;
	}
	return TRUE;
}

BOOL
AddTaggedFile(TAGGED_FILE *tag)
{
	if( _tag::m_Count >= MAX_TAGS || -1 != _tag::find(tag) ) return FALSE;
	memcpy(&_tag::m_tag[_tag::m_Count++], tag, sizeof(TAGGED_FILE));
	return TRUE;
}

BOOL
RemoveTaggedFile(TAGGED_FILE *tag)
{
	short index = _tag::find(tag);
	if( -1 != index ){
		short nbytes = (_tag::m_Count - index) * sizeof(TAGGED_FILE);
		memmove(&_tag::m_tag[index], &_tag::m_tag[index+1], nbytes);
		_tag::m_Count--;
		return TRUE;
	}
	return FALSE;
}

void
ClearTaggedFiles()
{
	_tag::m_Count = 0;
}

BOOL
IsTagged(TAGGED_FILE *tag)
{
	return BOOL( -1 != _tag::find(tag) );
}

#undef MAX_TAGS
