/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblsdk.h"

#ifndef PB_SDK
	#include <conio.h>
	#include <ctype.h>
	#include "compiler.h"
#endif

void
Input( char *buf, int len, int mode )
{
	int   ch;
	int   i;

	if( !(mode & INPUT_NOFIELD) )
	{
#ifdef __TURBOC__
		textbackground( 0x01 );
#else
		textattr(0x1F);
#endif
		for( ch = 0; ch <= len; ++ch ) putch( ' ' );
		for( ; ch > 0; --ch ) putch( '\b' );
	}

	for( i = 0;; ){
		ch = getch();

		if( '\r' == ch ){ buf[i] = EOS; return; }
		if( '\b' == ch )
		{
			if( 0 < i ){ --i; cprintf( "\b \b" ); }
			continue;
		}
		if( len == i ) continue;

		if( (mode & 0x0f) == INPUT_UPALL ) ch = toupper(ch);
		else if( ((mode & 0x0f) == INPUT_DIGITS) && !isdigit(ch) ) continue;
		else if( (mode & 0x0f) == INPUT_UPFIRST )
		{
			if( !i || isspace(buf[i - 1]) ) ch = toupper(ch);
		}

		if( mode & INPUT_PWD ) putch( Config->pwdchar );
		else putch( ch );
		buf[i++] = ch;
	}
}
