/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifdef PB_SDK
#error "Cannot compile in SDK mode! Use native Ask() instead."
#endif

#include "pblang.h"
#include "emulator.h"
#include <conio.h>
#include <ctype.h>

/*
 * SDK's Ask() function for off-line usage (ENGLISH language only)
*/
BOOL
Ask( BOOL def )
{
	zProLang    lang(Terminal);
	const char *pkeys;
	char        yesChar, noChar;

	if( !lang.Error() )
	{
		lang.Load(11);
		lang.Load(5);
		lang.Load(6);
	}

	if( !lang.Error() ) lang.Exec(11, False);
	pkeys = lang.GetItemKeys(11);
	yesChar = toupper(pkeys[0]);
	noChar = toupper(pkeys[1]);
	do{
		char ch = toupper( getch() );
		ch = ('\r' == ch) ? (def ? yesChar : noChar) : ch;

		if( yesChar == ch )
		{
			lang.Exec(5, False);
			return TRUE;
		}

		if( noChar == ch )
		{
			lang.Exec(6, False);
			return FALSE;
		}

	}while(1);
}
