/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "parsevar.h"
#include "parsedef.h"
#include "pblsdk.h"
#include "proboard.h"
#include "version.h"
#include "comdef.h"
#include "file.h"
#include "pbnames.h"
#include "date.h"

static char const * const szSex[3]       = { "unknown", "male", "female" };
static char const * const szState[2]     = { "off", "on" };
static char const * const szShortFormat  = "%d";
static char const * const szLongFormat   = "%ld";
static char const * const szUshortFormat = "%u";
static char const * const szNoName       = "** none **";

static void   DoRetrieveName(char *buf, int token);
static void   DoPortNumber(char *buf);
static void   DoTimeLog(char *buf, int token);
static long   DoExpiryDate();

static long   pb_getlastread(int areano, long userno);
static ushort pb_hmbtotal();
static ushort pb_hmbfirst();
static long   pb_highmsg(int areano);
static long   pb_totalmsg(int areano);

#define ONOFF(state)     strcpy(buf, szState[BOOLEAN(state)])
#define SHORT(snum)      sprintf(buf, szShortFormat, (snum))
#define USHORT(usnum)    sprintf(buf, szUshortFormat, (usnum))
#define LONG(lnum)       sprintf(buf, szLongFormat, (lnum))
#define DIREC(which)     strcpy(buf, pb_getdir(which))
#define STR(string)      strcpy(buf, string)
#define FLAGS(format)    strcpy(buf, pb_flagformat(format, CurUser->aFlags))
#define PBDATE(pbdate)   strcpy(buf, pb_fmtdate(pbdate))
#define PBTIME(pbtime)   strcpy(buf, pb_fmttime(pbtime))

char*
parse_token(char *result, int token, int style, int maxlen)
{
	const LIMIT    *UserLimit = pb_limit(CurUser->level);
		   time_t   timer = time(0);
		   char     buf[255];
	struct tm      *LocalTime = localtime(&timer);

	if( PDEF_ERROR == token || PDEF_DEAD == token )
		return 0;  // argh! invalid request!

	// parse macro code into a temporary buffer string
	switch( token )
	{
		case PDEF_USR_MLASTREAD:
			LONG(pb_getlastread(CurUser->msgArea, CurUser->record));
			break;
		case PDEF_MSG_HMBTOTAL  : USHORT(pb_hmbtotal()); break;
		case PDEF_MSG_HMBLOW    : USHORT(pb_hmbfirst()); break;
		case PDEF_MSG_LAST      : LONG(pb_highmsg(CurUser->msgArea)); break;
		case PDEF_MSG_TOTAL     : LONG(pb_totalmsg(CurUser->msgArea)); break;
		case PDEF_SYS_VERSION   : STR(__PBLIB_VERSION__); break;
		case PDEF_USR_EXPDAYS   : LONG(DoExpiryDate()); break;
		case PDEF_USR_FLAGS     : FLAGS(FLAGFMT_ALL); break;
		case PDEF_USR_FLAGSA    : FLAGS(FLAGFMT_A); break;
		case PDEF_USR_FLAGSB    : FLAGS(FLAGFMT_B); break;
		case PDEF_USR_FLAGSC    : FLAGS(FLAGFMT_C); break;
		case PDEF_USR_FLAGSD    : FLAGS(FLAGFMT_D); break;
		case PDEF_USR_KBLEFT    : SHORT(max(0L, UserLimit->daily_klimit-CurUser->kbToday)); break;
		case PDEF_USR_DELAYLEFT : SHORT(max(0, UserLimit->pre_download-TimeOnline())); break;
		case PDEF_USR_ANSI      : ONOFF(CurUser->uFlags & UFLAG_ANSI); break;
		case PDEF_USR_AVATAR    : ONOFF(CurUser->uFlags & UFLAG_AVATAR); break;
		case PDEF_USR_AVTPLUS   : ONOFF(CurUser->uFlags & UFLAG_AVTPLUS); break;
		case PDEF_USR_CLRSCR    : ONOFF(CurUser->uFlags & UFLAG_CLEAR); break;
		case PDEF_USR_FSED      : ONOFF(CurUser->uFlags & UFLAG_FSED); break;
		case PDEF_USR_IBM       : ONOFF(!(CurUser->uFlags & UFLAG_NOIBM)); break;
		case PDEF_USR_PAUSE     : ONOFF(CurUser->uFlags & UFLAG_PAUSE); break;
		case PDEF_USR_STACKING  : ONOFF(CurUser->uFlags & UFLAG_HOTKEYS); break;
		case PDEF_USR_CHECKMAIL : ONOFF(CurUser->checkMail); break;
		case PDEF_USR_CHECKFILES: ONOFF(CurUser->checkNewFiles); break;
		case PDEF_USR_SEX       : STR(szSex[CurUser->sex]); break;
		case PDEF_USR_RECNO     : LONG(CurUser->record); break;
		case PDEF_SYS_EVENTMIN  : SHORT(TimeUntilEvent()); break;
		case PDEF_SYS_MENUDIR   : DIREC(PBDIR_MENU); break;
		case PDEF_MSG_HMBDIR    : DIREC(PBDIR_MSGBASE); break;
		case PDEF_SYS_SYSTEM    : DIREC(PBDIR_SYS); break;
		case PDEF_SYS_TEXTFILES : DIREC(PBDIR_TEXT); break;
		case PDEF_SYS_STARTUP   : DIREC(PBDIR_STARTUP); break;
		case PDEF_SYS_NODELIST  : DIREC(PBDIR_NODELIST); break;
		case PDEF_SYS_UPLOAD    : DIREC(PBDIR_UPLOAD); break;
		case PDEF_SYS_PEX       : DIREC(PBDIR_PEX); break;
		case PDEF_SYS_PVTUP     : DIREC(PBDIR_PVTUPLOAD); break;
		case PDEF_SYS_SYSOP     : STR(Config->sysopname); break;
		case PDEF_USR_FORWARD   : STR(CurUser->forwardTo); break;
		case PDEF_USR_TLEFT     : SHORT(TimeLeft()); break;
		case PDEF_USR_TTOTAL    : LONG(CurUser->totalTimeUsed); break;
		case PDEF_USR_MINONLINE : SHORT(TimeOnline()); break;
		case PDEF_USR_TONLINE   : LONG(CurUser->timeUsed + TimeOnline()); break;
		case PDEF_USR_KBLIMIT   : SHORT(UserLimit->daily_klimit); break;
		case PDEF_USR_TLIMIT    : SHORT(UserLimit->timelimit); break;
		case PDEF_SYS_SHORTDOW  : strftime(buf, 10, "%a", LocalTime); break;
		case PDEF_SYS_WEEKDAY   : strftime(buf, 10, "%A", LocalTime); break;
		case PDEF_USR_DELAY     : SHORT(UserLimit->pre_download); break;
		case PDEF_USR_FGROUPNO  : USHORT(CurUser->fileGroup); break;
		case PDEF_USR_FAREANO   : USHORT(CurUser->fileArea); break;
		case PDEF_USR_MGROUPNO  : USHORT(CurUser->msgGroup); break;
		case PDEF_USR_MAREANO   : USHORT(CurUser->msgArea); break;
		case PDEF_SYS_BAUD      : LONG(BaudRate); break;
		case PDEF_SYS_DATE      : PBDATE(0); break;
		case PDEF_SYS_TIME      : PBTIME(0); break;
		case PDEF_SYS_LASTCALLER: STR(PrevUser); break;
		case PDEF_SYS_NODE      : SHORT(NodeNumber); break;
		case PDEF_SYS_PAGES     : SHORT(*PageCount); break;
		case PDEF_SYS_USERS     : SHORT(NumUsers); break;
		case PDEF_USR_ADDRESS1  : STR(CurUser->address1); break;
		case PDEF_USR_ADDRESS2  : STR(CurUser->address2); break;
		case PDEF_USR_ADDRESS3  : STR(CurUser->address3); break;
		case PDEF_USR_ALIAS     : STR(CurUser->alias); break;
		case PDEF_USR_DOB       : PBDATE(CurUser->birthDate); break;
		case PDEF_USR_CALLS     : LONG(CurUser->timesCalled); break;
		case PDEF_USR_CITY      : STR(CurUser->city); break;
		case PDEF_USR_COMMENT   : STR(CurUser->comment); break;
		case PDEF_USR_COUNTRY   : STR(CurUser->country); break;
		case PDEF_USR_CREDIT    : LONG(CurUser->credit); break;
		case PDEF_USR_DATA      : STR(CurUser->dataPhone); break;
		case PDEF_USR_DOWNS     : LONG(CurUser->numDownloads); break;
		case PDEF_USR_EXPDATE   : PBDATE(CurUser->expDate); break;
		case PDEF_USR_FAX       : STR(CurUser->faxPhone); break;
		case PDEF_USR_FIRSTCALL : PBDATE(CurUser->firstDate); break;
		case PDEF_USR_FIRST     : STR(UserFirstName); break;
		case PDEF_USR_KBDOWN    : LONG(CurUser->kbDownloaded); break;
		case PDEF_USR_KBUP      : LONG(CurUser->kbUploaded); break;
		case PDEF_USR_LANGUAGE  : STR(CurUser->language); break;
		case PDEF_USR_LASTTIME  : PBTIME(CurUser->lastTime); break;
		case PDEF_USR_LASTDATE  : PBDATE(CurUser->lastDate); break;
		case PDEF_USR_LEVEL     : USHORT(CurUser->level); break;
		case PDEF_USR_ID        : STR(pb_limit(CurUser->level)->id); break;
		case PDEF_SYS_MENU      : STR(CurMenu); break;
		case PDEF_USR_MWRITTEN  : LONG(CurUser->msgsPosted); break;
		case PDEF_USR_NAME      : STR(CurUser->name); break;
		case PDEF_USR_PASSWD    : STR(CurUser->passWord); break;
		case PDEF_USR_NUMLINES  : SHORT(CurUser->screenLength); break;
		case PDEF_USR_SECONLINE : // fall-through to next case
		case PDEF_USR_SECTODAY  : STR("0"); break;
		case PDEF_USR_STATE     : STR(CurUser->state); break;
		case PDEF_USR_UPLOADS   : LONG(CurUser->numUploads); break;
		case PDEF_USR_VOICE     : STR(CurUser->voicePhone); break;
		case PDEF_USR_LASTPWD   : PBDATE(CurUser->lastPwdChange); break;
		case PDEF_USR_LASTFILES : PBDATE(CurUser->lastNewFilesCheck); break;
		case PDEF_TB_TDIFF      : SHORT(CurUser->tbTimeBalance); break;
		case PDEF_TB_KBDIFF     : SHORT(CurUser->tbKbBalance); break;
		case PDEF_TB_TGET       : SHORT(CurUser->tbTimeWithdrawn); break;
		case PDEF_TB_KBGET      : SHORT(CurUser->tbKbWithdrawn); break;
		case PDEF_TB_TPUT       : USHORT(CurUser->tbTimeDeposited); break;
		case PDEF_TB_KBPUT      : USHORT(CurUser->tbKbDeposited); break;
		case PDEF_TB_TLOAN      : USHORT(CurUser->tbTimeLoaned); break;
		case PDEF_TB_KBLOAN     : USHORT(CurUser->tbKbLoaned); break;
		case PDEF_TB_LAST       : PBDATE(CurUser->tbLastUsed); break;
		case PDEF_TB_TPAY       : PBDATE(CurUser->tbTimePayback); break;
		case PDEF_TB_KBPAY      : PBDATE(CurUser->tbKbPayback); break;
		case PDEF_USR_FAREA     : // fall-through to next case
		case PDEF_USR_FAREADIR  : // fall-through to next case
		case PDEF_USR_FGROUP    : // fall-through to next case
		case PDEF_USR_MAREA     : // fall-through to next case
		case PDEF_USR_MGROUP    : DoRetrieveName(buf, token); break;
		case PDEF_SYS_PORT      : DoPortNumber(buf); break;
		case PDEF_SYS_TOTALCALLS: // fall-through to next case
		case PDEF_SYS_ACTIVE    : DoTimeLog(buf, token); break;
		default                 : buf[0] = EOS; break;
	}

	// if no max length, simply copy the result
	if( 0 == maxlen ) strcpy(result, buf);
	else
	{
		int    ofs;
		size_t slen = strlen(buf);

		// format the result into the static buffer
		memset(result, ' ', maxlen);
		switch( style )
		{
			case PDEF_JUST_LEFT:
				memcpy(result, buf, slen);
				break;

			case PDEF_JUST_RIGHT:
				ofs = max(0, int(maxlen - slen));
				memcpy(&result[ofs], buf, slen);
				break;

			case PDEF_JUST_CENTER:
				ofs = max(0, int((maxlen - slen) / 2));
				memcpy(&result[ofs], buf, slen);
				break;
		}
		// cut off any excess characters here
		result[maxlen] = EOS;
	}
	return result;
}

/* *************************************************************************
 * helper functions local to this module
*/
void
DoRetrieveName(char *buf, int token)
{
	GROUP_PB group;

	buf[0] = EOS;
	switch( token )
	{
		case PDEF_USR_FAREA:
		case PDEF_USR_FAREADIR:
			if( 0 < CurUser->fileArea && CurUser->fileArea < NumFileAreas() )
			{
				FILECFG fileArea;
				if( -1 != ReadFileArea(CurUser->fileArea, &fileArea) )
				{
					if( PDEF_USR_FAREA == token ) strcpy(buf, fileArea.name);
					else file_appchr(buf, fileArea.filepath);
				}
			}
			break;

		case PDEF_USR_MAREA:
			if( 0 < CurUser->msgArea && CurUser->msgArea < NumMsgAreas() )
			{
				MESSAGES msgArea;
				if( ReadMsgArea(CurUser->msgArea, &msgArea) )
					strcpy(buf, msgArea.name);
			}
			break;

		case PDEF_USR_FGROUP:
			if( 0 < CurUser->fileGroup )
			{
				if( pb_group(CurUser->fileGroup, &group, False) )
					strcpy(buf, group.name);
			}
			break;

		case PDEF_USR_MGROUP:
			if( 0 < CurUser->msgGroup )
			{
				if( pb_group(CurUser->msgGroup, &group, True) )
					strcpy(buf, group.name);
			}
			break;
	}

	if( EOS == buf[0] ) strcpy(buf, szNoName);
}

void
DoPortNumber(char *buf)
{
#ifdef PB_SDK
	ParseStringVars("@<PORT>@", buf, 20);
#else
	strcpy(buf, "0");
#endif
}

void
DoTimeLog(char *buf, int token)
{
	*buf = EOS;
	FILE *fp = pb_fopen(fnTIMELOG, "rb", PBDIR_SYS);
	if( fp )
	{
		TIMELOG TimeLog;

		file_read(fp, &TimeLog);
		fclose(fp);
		if( PDEF_SYS_TOTALCALLS == token ) LONG(TimeLog.totalcalls);
		else if( PDEF_SYS_ACTIVE == token ) SHORT(TimeLog.numdays);
	}
}

long
DoExpiryDate()
{
	zDate expiry((zDate::month)CurUser->expDate[1],
				CurUser->expDate[0], CurUser->expDate[2]+1900);
	return expiry - zDate::Today();
}

long
pb_getlastread(int /*areano*/, long /*userno*/)
{
	return 0L;
}

ushort
pb_hmbtotal()
{
	return 0;
}

ushort pb_hmbfirst()
{
	return 0;
}

long
pb_highmsg(int /*areano*/)
{
	return 0L;
}

long
pb_totalmsg(int /*areano*/)
{
	return 0L;
}

#undef ONOFF
#undef SHORT
#undef USHORT
#undef LONG
#undef DIREC
#undef STR
#undef FLAGS
#undef PBDATE
#undef PBTIME
