/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "progbar.h"

#ifndef PB_SDK
	#include <conio.h>
	#include "compiler.h"
#else
	#include "pblibc.h"
    #include "pblsdk.h"
#endif

zProgBar::zProgBar(zRect &r, ushort fg, ushort bg):
	bounds(r),
    foreChar(fg & 0x00ff),
    foreAtrib(fg >> 8)
{
	curPercent = curOffset = pct = 0;
    curProgress = taskSize = 0L;

	size.x = bounds.Width();
	size.y = bounds.Height();

	pctPerChar = 100 / bounds.Width();
	adjCount   = 100 % bounds.Width();

	uchar ch = bg & 0x00ff;
	textattr(bg >> 8);

	for( short i = 0; i < size.y; ++i )
	{
		for( short j = 0; j < size.x; ++j )
		{
			gotoxy(bounds.a.x + j, bounds.a.y + i);
			putch(ch);
		}
	}
}

void
zProgBar::draw()
{
	if( curOffset <= size.x )
	{
		textattr(foreAtrib);
		for( short i = 0; i < size.y; ++i )
		{
			for( short j = 0; j < curOffset; ++j )
			{
				gotoxy(bounds.a.x + j, bounds.a.y + i);
				putch(foreChar);
			}
		}
	}
}

void
zProgBar::update( ulong aStepSize )
{
	short delta;
	short pctChar = pctPerChar;

	curProgress += aStepSize;
	curPercent = curProgress * 100L / taskSize;
	delta = curPercent - pct;

	if( curOffset < adjCount ) pctChar++;

	if( delta >= pctChar )
	{
		if( delta >= 100 ) curOffset = size.x;
		else curOffset += delta / pctChar;
		draw();
		pct = curPercent;
	}
}

