/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "proboard.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
	#include <ctype.h>
	#include <stdlib.h>
#else
	#include "pblibc.h"
#endif

/*
 * attempt to identify the version of proboard used
*/
Boolean
pb_getver(int *maxver, int *minver, int *beta)
{
	Boolean  retval = False;
	FILE    *fp     = pb_fopen("proboard.exe", "rb", PBDIR_SYS);

	if( fp )
	{
		char buf[0x4000], *p;

		setvbuf(fp, 0, _IOFBF, 0x8000);
		fread(buf, sizeof(buf), 1, fp);
		while( !feof(fp) )
		{
			for( int i = 0; i < sizeof(buf); ++i )
			{
				if( 'P' == buf[i] && 0 == memcmp(&buf[i], "ProBoard v", 10) )
				{
					buf[i + 20] = '\0';
					sscanf(&buf[i+10], "%d.%d", maxver, minver);
					if( 0 != (p = strchr(&buf[i+10], '')) ) *beta = atoi(p+1);
					else *beta = 0;
					retval = True;
					goto found;
				}
			}
			fread(buf, sizeof(buf), 1, fp);
		}
	}

found:
	fclose(fp);
	return retval;
}
