/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "proboard.h"
#include "file.h"
#include "stdmac.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <string.h>
#endif

// get a proboard directory (always has a trailing backslash!)
char*
pb_getdir( pbdir_t where )
{
	static char dir[MAXPATH];

	switch( where ){
		case PBDIR_PEX       : strcpy(dir, Config->pexpath);       break;
		case PBDIR_MSGBASE   : // same as userbase path - fall-through
		case PBDIR_USER      : strcpy(dir, Config->msgpath);       break;
		case PBDIR_NODELIST  : strcpy(dir, Config->nodelistdir);   break;
		case PBDIR_TEXT      : strcpy(dir, Config->txtpath);       break;
		case PBDIR_MENU      : strcpy(dir, Config->mnupath);       break;
		case PBDIR_STARTUP   : strcpy(dir, StartupPath);           break;
		case PBDIR_UPLOAD    : strcpy(dir, Config->uploadpath);    break;
		case PBDIR_PVTUPLOAD : strcpy(dir, Config->pvtuploadpath); break;
		case PBDIR_RIPFILES  : strcpy(dir, Config->RIPpath);       break;
		case PBDIR_RIPICONS  : strcpy(dir, Config->iconspath);     break;
		case PBDIR_SYS       : // system directory and unknown request
		default              : strcpy(dir, SysPath);               break;
	}
	return file_appchr(dir, 0);
}
