/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
#else
	#include "pblibc.h"
#endif

// convert a long number into a MegaNum (base 36)
char*
ltom( long value )
{
	static const char b36toa[36] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	static char       buf[8]; /* the maximum length is 7 */
	char *p = buf;
	int v;

	do{
		v = (int)(value % 36L);
		*p++ = b36toa[v];
		value = value / 36L;
	}while( value >= 36 );

	if( value ) *p++ = b36toa[(int)value];
	*p = EOS;
	return strrev( buf );
}
