/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "file.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
#endif

/*
 * changes the file extension of src to ext, returns dest
 * if ext is NULL, remove the existing extension, ext must have the period!
*/
char*
file_chext( char *dest, const char *src, const char *ext )
{
	char *p = strrchr( strcpy( dest, src ), '.' );

	/* no period, simply append extension if needed */
	if( !p ){
		if( ext ) strcat( dest, ext );
		return dest;
	}

	/* see if we have a period in a subdirectory specification */
	if( strlen(p) > 4 || strchr(p, '\\') || strchr(p, '/') ){
		if( ext ) strcat( dest, ext );
		return dest;
	}

	/* see if we need to add, change or remove the extension */
	if( ext ) strcpy( p, ext );
	else *p = EOS;

	return dest;
}

