/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"
#include "compiler.h"

/*
 * r e c o r d - b a s e   f i l e   l o c k i n g
 * 
 * this module implements the record-based file locking routines
*/
#ifndef PB_SDK
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

/*
 * locking function, local helper routine
*/
static int
DoLock(int fd, long whence, long len, int fnr)
{
	union REGS regs;

	regs.h.ah = 0x5c;
	regs.h.al = fnr;
	regs.x.bx = fd;
	regs.x.cx = (int)(whence >> 16);
	regs.x.dx = (int)whence;
	regs.x.si = (int)(len >> 16);
	regs.x.di = (int)len;
	int86(0x21, &regs, &regs);

	if( regs.x.cflag ) return regs.h.al;
	else return 0;
}

/*
 * waits for 1 second, local helper routine
*/
static void
Wait1Sec(void)
{
	struct dostime_t start, end;
	int endsec;

	_dos_gettime(&start);
	if( 59 == start.second ) endsec = 0;
	else endsec = start.second + 1;

	do{
		_dos_gettime(&end);
	}while( start.second == end.second );

	do{
		_dos_gettime(&end);
	}while( start.second == endsec && start.hsecond > end.hsecond);
}

/*
 * will try locking for 15 seconds
*/
int
_dos_lock(int fd, long whence, long len)
{
	int retval, wait;

	for( wait = 15; wait; wait-- )
	{
		if( 0 == (retval = DoLock(fd, whence, len, 0)) ) break;
		Wait1Sec();
	}

	return retval;
}

/*
 * immediate unlock (len and whence must be same from call to _dos_lock)
*/
int
_dos_unlock(int fd, long whence, long len)
{
	return DoLock(fd, whence, len, 1);
}

/*
 * tries to lock the region once
*/
int
_dos_locknow(int fd, long whence, long len)
{
	return DoLock(fd, whence, len, 0);
}
