/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"

/*
 * t i m e   s l i c e   r e l e a s e   r o u t i n e s
 * 
 * this module implements the os detection and time slice release functions
*/
#ifndef PB_SDK
	#include <dos.h>
#else
	#include "pblibc.h"
#endif

static int _currentOS = __DOS;

/*
 * detects the current OS
*/
int
_dos_detect_os( void )
{
	union REGS r;

	r.x.cx = 0x4445;
	r.x.dx = 0x5351;
	r.x.ax = 0x2b01;
	int86( 0x21, &r, &r );
	if( 0xff == r.h.al ) goto _checkOS2;
	return _currentOS = __DV;

_checkOS2:
	r.h.ah = 0x30;
	int86( 0x21, &r, &r );
	if( 0x0a > r.h.al ) goto _checkWin;
	return _currentOS = __OS2;

_checkWin:
	r.x.ax = 0x4680;
	int86( 0x2f, &r, &r );
	if( 0x0000 == r.x.ax ) return _currentOS = __WIN;
	r.x.ax = 0x1600;
	int86( 0x2f, &r, &r );
	if( 0x00 == r.h.al || 0x80 == r.h.al || 0xff == r.h.al )
		return _currentOS = __DOS;
	else return _currentOS = __WIN;
}

/*
 * releases a timeslice
*/
void
_dos_idle( void )
{
	union REGS r;

	switch( _currentOS )
	{
		case __DV:
			r.x.ax = 0x1000;
			int86( 0x15, &r, &r );
		    break;

		case __WIN:
			r.x.ax = 0x1680;
			int86( 0x2f, &r, &r );
		    break;

		case __DOS:
		case __OS2:
		default   :
			int86( 0x28, &r, &r );
	}
}
