/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "dlist.h"

zListCursor::zListCursor(zDoubleList &aList, Boolean atStart):
	list(aList)
{
	if( atStart )
	{
		focus = list.root;
		cpos = 1L;
	}
	else
	{
		focus = list.focus;
		cpos = list.cpos;
	}
}

zListCursor::zListCursor(zListCursor &aListCursor):
	list(aListCursor.list),
	cpos(aListCursor.cpos),
	focus(aListCursor.focus)
{
}

ushort
zListCursor::begin()
{
	if( list.count )
	{
		focus = list.root;
		cpos = 1L;
		return 1;
	}
	return 0;
}

ushort
zListCursor::end()
{
	if( list.count )
	{
		focus = list.root->prev;
		cpos = list.count;
		return 1;
	}
	return 0;
}


void*
zListCursor::get() const
{
	return list.count ? focus->data : 0;
}

ushort
zListCursor::update(void *data)
{
	if( focus )
	{
		focus->data = data;
		return 1;
	}
	return 0;
}

ushort
zListCursor::next()
{
	if( cpos < list.count )
	{
    	cpos++;
        focus = focus->next;
    	return 1;
	}
    return 0;
}


zListCursor&
zListCursor::operator=(zListCursor &aListCursor)
{
	list  = aListCursor.list;
	cpos  = aListCursor.cpos;
	focus = aListCursor.focus;
	return *this;
}

ushort
zListCursor::operator+=(short nelem)
{
	Boolean fwd = True;
    ushort  rv;

    if( nelem < 0 )
    {
		fwd = False;
        nelem = -nelem;
    }

    for(rv = 1; rv && nelem; --nelem)
    {
    	if( fwd ) rv = next();
        else rv = prev();
    }

    return rv;
}

ushort
zListCursor::operator-=(short nelem)
{
	Boolean bck = True;
    ushort  rv;

    if( nelem < 0 )
    {
    	bck = False;
        nelem = -nelem;
	}

    for(rv = 1; rv && nelem; --nelem)
    {
    	if( bck ) rv = prev();
        else rv = next();
    }

    return rv;
}

Boolean
zListCursor::atEnd() const
{
	return (cpos == list.count) ? True : False;
}

Boolean
zListCursor::atStart() const
{
	return (1L == cpos) ? True : False;
}

ushort
zListCursor::prev()
{
	if( cpos > 1L )
	{
		cpos--;
		focus = focus->prev;
		return 1;
	}
	return 0;
}

void
zListCursor::sync()
{
	focus = list.focus;
    cpos = list.cpos;
}

