/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

static  fpCompFunc  _comp;
static  size_t      _eWidth;
static  char       *_base;

/*
 * the real Quicker Sort function (algorithm by Hoare)
*/
static void
DoSort( size_t left, size_t right )
{
	int  i, j;
	char *pivot, *pRight, *pLeft, *p1, *p2;

	/* determine the pivot element and setup variables */
	pivot  = _base + (_eWidth * ((left + right) / 2));
	pLeft  = _base + (_eWidth * left);
	pRight = _base + (_eWidth * right);

	/*
	 * move all elements smaller than the pivot to its left and all
	 * larger than it, to the right.
	*/
	do{
		/* find element larger than pivot to left of the pivot */
		while( _comp(pLeft, pivot) < 0 && pLeft < pRight )
			pLeft += _eWidth;
		/* find element smaller than pivot to the right of the pivot */
		while( _comp(pRight, pivot) > 0 && pRight > pLeft )
			pRight -= _eWidth;

		/* exchange the two elements */
		if( pLeft <= pRight ){
			p1 = pRight; p2 = pLeft;
			for( i = 0; i < _eWidth; ++i ){
				char t = *p1;
				*p1++ = *p2;
				*p2++ = t;
			}
		}

		pLeft += _eWidth; pRight -= _eWidth;
	}while( pLeft <= pRight );

	/* sort the left and right partitions */
	j = (int)((pRight - _base) / _eWidth);
	i = (int)((pLeft - _base) / _eWidth);
	if( left < j )  DoSort( left, j );
	if( i < right ) DoSort( i, right );
}

/*
 * wrapper for the real Quicker Sort function
*/
void
qsort( void *base, size_t nelem, size_t width, fpCompFunc fcmp )
{
	if( 0 == (_eWidth = width) ) return;
	_comp = fcmp;
	_base = (char *)base;

	DoSort( 0, nelem - 1 );
}
