/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

/*
 * gets the current working directory in form 'D:\PATH'. The drive letter
 * and colon are always present and there's no terminating backslash. If
 * 'buflen' is less than the resulting path or if another error occurs,
 * NULL is returned. Otherwise, the result is copied into 'path' and 'path'
 * is returned (NUL-terminated string).
*/
char*
getcwd( char *path, int buflen )
{
	char   buf[127];
	union  REGS  regs;
	struct SREGS sregs;

	/* get the current directory in a local buffer */
	regs.h.ah = 0x47;
	regs.h.dl = 0;
	regs.x.si = FP_OFF(buf);
	sregs.ds  = FP_SEG(buf);
	int86x( 0x21, &regs, &regs, &sregs );
	if( 0 != regs.x.cflag ) return NULL;

	/* make sure we have enough space to store the result */
	if( strlen(buf) + 3 >= buflen ) return NULL;

	/* get the current default drive */
	regs.h.ah = 0x19;
	int86( 0x21, &regs, &regs );

	/* add the leading drive letter, colon and backslash and return path */
	*path = regs.h.al + 'A'; strcpy( path + 1, ":\\" );
	return strcat( path, buf );
}

