/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"
#include "compiler.h"

void
_dos_getdate( struct dosdate_t *datep )
{
	union REGS r;

	r.h.ah = 0x2a;
	int86(0x21, &r, &r);
	datep->dayofweek = r.h.al;
	datep->day = r.h.dl;
	datep->month = r.h.dh;
	datep->year = r.x.cx;
}

void
_dos_gettime( struct dostime_t *timep )
{
	union REGS r;

	r.h.ah = 0x2c;
	int86(0x21, &r, &r);
	timep->hour = r.h.ch;
	timep->minute = r.h.cl;
	timep->second = r.h.dh;
    timep->hsecond = r.h.dl;
}
