/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_TERMBUF_H
#define INCLUDED_TERMBUF_H
#include "typedef.h"
#include "comdef.h"

class term_ctrl;

class term_buff
{
	friend class zTerminal;
public:
	term_buff(size_t aSize);
	term_buff(const term_buff &buf);
	~term_buff();

	void put(char aChar);
	int  get();
	void flush();

	int    getCount() const { return m_pos; }
	void   RegisterTerm(term_ctrl *term) { m_term = term;   }
	void   setPos(size_t nPos) { m_pos = min(nPos, m_size); }
	char*  bp()                { return m_buf;              }

private:
	char      *m_buf;
	size_t     m_size;
	size_t     m_pos;
	term_ctrl *m_term;
};

#endif /* INCLUDED_TERMBUF_H */
